/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WindEntity
extends Mob {
    private static final EntityDataAccessor<Boolean> AGGRESSIVE = SynchedEntityData.defineId(WindEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> TARGET_PLAYER = SynchedEntityData.defineId(WindEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final int MAX_LIFETIME = 600;
    private static final int AGGRESSIVE_LIFETIME = 200;
    private int lifetimeTicks = 0;
    private Vec3 windDirection;
    private int damageTimer = 0;

    public WindEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
        double angle = level.random.nextDouble() * Math.PI * 2.0;
        this.windDirection = new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).normalize();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AGGRESSIVE, (Object)false);
        builder.define(TARGET_PLAYER, Optional.empty());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes();
    }

    public void setAggressive(boolean aggressive) {
        this.entityData.set(AGGRESSIVE, (Object)aggressive);
    }

    public boolean isAggressive() {
        return (Boolean)this.entityData.get(AGGRESSIVE);
    }

    public void setTargetPlayer(UUID uuid) {
        this.entityData.set(TARGET_PLAYER, Optional.of(uuid));
    }

    public Optional<UUID> getTargetPlayer() {
        return (Optional)this.entityData.get(TARGET_PLAYER);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            int maxLife;
            ++this.lifetimeTicks;
            int n = maxLife = this.isAggressive() ? 200 : 600;
            if (this.isAggressive() && this.getTargetPlayer().isPresent()) {
                ServerPlayer target = (ServerPlayer)this.level().getPlayerByUUID(this.getTargetPlayer().get());
                if (target != null && target.isAlive()) {
                    Vec3 toTarget = target.position().subtract(this.position()).normalize();
                    this.windDirection = this.windDirection.lerp(toTarget, 0.1);
                    this.setDeltaMovement(this.windDirection.scale(0.3));
                } else {
                    this.setDeltaMovement(this.windDirection.scale(0.1));
                }
            } else {
                this.setDeltaMovement(this.windDirection.scale(0.1));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            List nearby = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0));
            for (LivingEntity entity : nearby) {
                if (this.isAggressive() && this.damageTimer <= 0) {
                    float damage = 2.0f + this.random.nextFloat();
                    if (entity.getHealth() > damage) {
                        entity.hurt(this.damageSources().magic(), damage);
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
                            CatamountPlayerDataAttachment.setData((Player)player, data.addPoints((int)damage));
                        }
                    } else {
                        entity.hurt(this.damageSources().magic(), 0.0f);
                    }
                    this.damageTimer = 20;
                    continue;
                }
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 0, false, false));
            }
            if (this.damageTimer > 0) {
                --this.damageTimer;
            }
            if (this.lifetimeTicks >= maxLife) {
                this.discard();
            }
        }
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.lifetimeTicks = tag.getInt("LifetimeTicks");
        this.setAggressive(tag.getBoolean("Aggressive"));
        if (tag.hasUUID("TargetPlayer")) {
            this.setTargetPlayer(tag.getUUID("TargetPlayer"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("LifetimeTicks", this.lifetimeTicks);
        tag.putBoolean("Aggressive", this.isAggressive());
        this.getTargetPlayer().ifPresent(uuid -> tag.putUUID("TargetPlayer", uuid));
    }
}

