/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import dev.sterner.the_catamount.entity.task.CatamountPounceTask;
import dev.sterner.the_catamount.entity.task.CatamountSmoothLookAtTask;
import dev.sterner.the_catamount.entity.task.GeckoMeleeAttackTask;
import dev.sterner.the_catamount.registry.TCSensorTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;

public class CatamountBrain {
    public static final List<SensorType<? extends Sensor<? super CatamountEntity>>> SENSORS = List.of(SensorType.NEAREST_PLAYERS, SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY, TCSensorTypes.CATAMOUNT_SENSOR);
    public static final List<MemoryModuleType<?>> MEMORIES = List.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.ANGRY_AT, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.AVOID_TARGET);

    public static Brain<?> makeBrain(CatamountEntity catamount, Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORIES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        CatamountBrain.addCoreActivities((Brain<CatamountEntity>)brain);
        CatamountBrain.addIdleActivities((Brain<CatamountEntity>)brain);
        CatamountBrain.addFightActivities(catamount, (Brain<CatamountEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addFightActivities(CatamountEntity catamount, Brain<CatamountEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(entity -> !CatamountBrain.isPreferredAttackTarget(catamount, entity), BrainUtils::setTargetInvalid, (boolean)false), (Object)((Object)new CatamountSmoothLookAtTask()), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.2f), new CatamountPounceTask<CatamountEntity>((level, entity, time) -> entity.setAttacking(true), (level, entity, time) -> entity.setAttacking(false), 40, 20, 10.0), new GeckoMeleeAttackTask<CatamountEntity>((level, entity, time) -> entity.setAttacking(true), (level, entity, time) -> entity.setAttacking(false), 20, 14.0, 7.0)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void addIdleActivities(Brain<CatamountEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(CatamountBrain::findNearestValidTarget), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.6f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2)))));
    }

    private static void addCoreActivities(Brain<CatamountEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.6f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    public static void updateActivity(CatamountEntity catamount) {
        Brain<CatamountEntity> brain = catamount.getBrain();
        CatamountBrain.updateCrouchState(catamount);
        Activity currentActivity = brain.getActiveNonCoreActivity().orElse(null);
        Activity desiredActivity = CatamountBrain.getDesiredActivity(catamount);
        if (currentActivity != desiredActivity) {
            brain.setActiveActivityIfPossible(desiredActivity);
        }
    }

    private static void updateCrouchState(CatamountEntity catamount) {
        Optional<? extends LivingEntity> target = CatamountBrain.getAttackTarget(catamount);
        if (target.isPresent()) {
            LivingEntity entity = target.get();
            double distance = catamount.distanceToSqr((Entity)entity);
            boolean shouldCrouch = entity instanceof Player && distance < 64.0 || (double)entity.getBbHeight() < 2.0 && distance < 36.0;
            catamount.setCrouched(shouldCrouch);
        } else {
            double speed = catamount.getDeltaMovement().horizontalDistance();
            if (speed < 0.1) {
                catamount.setCrouched(false);
            }
        }
    }

    private static Activity getDesiredActivity(CatamountEntity catamount) {
        if (catamount.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return Activity.FIGHT;
        }
        return Activity.IDLE;
    }

    private static boolean isPreferredAttackTarget(CatamountEntity catamount, LivingEntity target) {
        return CatamountBrain.getAttackTarget(catamount).filter(preferredTarget -> preferredTarget == target).isPresent();
    }

    private static Optional<? extends LivingEntity> getAttackTarget(CatamountEntity catamount) {
        Optional attackTarget = catamount.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (attackTarget.isPresent()) {
            return attackTarget;
        }
        return catamount.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    private static Optional<? extends LivingEntity> findNearestValidTarget(CatamountEntity catamount) {
        Brain<CatamountEntity> brain = catamount.getBrain();
        Optional currentTarget = brain.getMemory(MemoryModuleType.ATTACK_TARGET);
        if (currentTarget.isPresent() && CatamountBrain.isTargetStillValid(catamount, (LivingEntity)currentTarget.get())) {
            return currentTarget;
        }
        Optional nearestAttackable = brain.getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
        if (nearestAttackable.isPresent() && CatamountBrain.isTargetStillValid(catamount, (LivingEntity)nearestAttackable.get())) {
            return nearestAttackable;
        }
        return brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(entities -> entities.findClosest(entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && CatamountBrain.isValidPrey(living = entity) && !CatamountBrain.isOwner(catamount, living) && catamount.hasLineOfSight((Entity)living);
        }));
    }

    private static boolean isTargetStillValid(CatamountEntity catamount, LivingEntity target) {
        return target.isAlive() && catamount.distanceToSqr((Entity)target) < 1024.0 && CatamountBrain.isValidPrey(target) && !CatamountBrain.isOwner(catamount, target);
    }

    public static boolean isValidPrey(LivingEntity entity) {
        return entity instanceof Animal || entity instanceof AbstractVillager || entity instanceof Player;
    }

    private static boolean isOwner(CatamountEntity catamount, LivingEntity entity) {
        if (catamount.isFeedingFrenzy()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return catamount.getOwnerUUID().map(uuid -> uuid.equals(player.getUUID())).orElse(false);
        }
        return false;
    }
}

