/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.sensor;

import com.google.common.collect.ImmutableSet;
import dev.sterner.the_catamount.entity.CatamountEntity;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;

public class CatamountPreySensor
extends Sensor<CatamountEntity> {
    private static final double DETECTION_RANGE = 32.0;

    protected void doTick(ServerLevel level, CatamountEntity catamount) {
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, catamount.getBoundingBox().inflate(32.0), entity -> entity != catamount && entity.isAlive());
        List<LivingEntity> validPrey = nearbyEntities.stream().filter(this::isValidPrey).filter(entity -> !this.isOwner(catamount, (LivingEntity)entity)).toList();
        Optional<LivingEntity> nearestTarget = validPrey.stream().filter(entity -> catamount.hasLineOfSight((Entity)entity)).min(Comparator.comparingDouble(arg_0 -> ((CatamountEntity)catamount).distanceToSqr(arg_0)));
        if (nearestTarget.isPresent()) {
            catamount.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, (Object)nearestTarget.get());
            if (!catamount.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                catamount.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)nearestTarget.get());
            }
        } else {
            catamount.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE);
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ATTACK_TARGET);
    }

    private boolean isValidPrey(LivingEntity entity) {
        return entity instanceof Animal || entity instanceof AbstractVillager || entity instanceof Player;
    }

    private boolean isOwner(CatamountEntity catamount, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return catamount.getOwnerUUID().map(uuid -> uuid.equals(player.getUUID())).orElse(false);
        }
        return false;
    }
}

