/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.task;

import com.google.common.collect.ImmutableMap;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class CatamountPounceTask<T extends CatamountEntity>
extends Behavior<T> {
    private final int interval;
    private final double animationTimeOfAttack;
    private long animationTime = 0L;
    private final int animationDuration;
    private final RunTask<T> runTask;
    private final FinishRunningTask<T> finishRunningTask;
    private boolean hasLeaped = false;

    public CatamountPounceTask(RunTask<T> runTask, FinishRunningTask<T> finishRunningTask, int interval, int animationDuration, double animationTimeOfAttack) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
        this.interval = interval;
        this.animationDuration = animationDuration;
        this.animationTimeOfAttack = animationTimeOfAttack;
        this.runTask = runTask;
        this.finishRunningTask = finishRunningTask;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T entity) {
        LivingEntity target = BrainUtils.getAttackTarget(entity);
        if (target == null) {
            return false;
        }
        double distance = entity.distanceToSqr((Entity)target);
        boolean isInRange = distance >= 9.0 && distance <= 36.0;
        boolean targetIsSmall = (double)target.getBbHeight() < 2.0;
        boolean notCrouched = !((CatamountEntity)((Object)entity)).isCrouched();
        boolean canSee = BehaviorUtils.canSee(entity, (LivingEntity)target);
        return notCrouched && targetIsSmall && isInRange && canSee;
    }

    protected void start(ServerLevel level, T entity, long gameTime) {
        entity.setAggressive(true);
        LivingEntity target = BrainUtils.getAttackTarget(entity);
        if (target != null) {
            entity.setTarget(target);
            BehaviorUtils.lookAtEntity(entity, (LivingEntity)target);
            this.runTask.run(level, entity, gameTime);
            ((CatamountEntity)((Object)entity)).setCrouched(true);
            this.animationTime = gameTime + (long)this.animationDuration;
            this.hasLeaped = false;
        }
    }

    protected boolean canStillUse(ServerLevel level, T entity, long gameTime) {
        return gameTime < this.animationTime && ((CatamountEntity)((Object)entity)).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET);
    }

    protected void tick(ServerLevel level, T entity, long gameTime) {
        LivingEntity target = BrainUtils.getAttackTarget(entity);
        if (target == null) {
            return;
        }
        if (!this.hasLeaped && gameTime >= this.animationTime - (long)this.animationDuration + 2L) {
            this.performLeap(entity, target);
            this.hasLeaped = true;
        }
        if ((double)this.animationTime == (double)gameTime + this.animationTimeOfAttack) {
            entity.swing(InteractionHand.MAIN_HAND);
            if (entity.distanceToSqr((Entity)target) < 9.0) {
                ((CatamountEntity)((Object)entity)).doHurtTarget((Entity)target);
                if (target.isAlive()) {
                    target.makeStuckInBlock(level.getBlockState(entity.blockPosition().above()), new Vec3(0.25, 0.05, 0.25));
                }
            }
        }
        BehaviorUtils.lookAtEntity(entity, (LivingEntity)target);
    }

    protected void stop(ServerLevel level, T entity, long gameTime) {
        entity.setAggressive(false);
        this.finishRunningTask.run(level, entity, gameTime);
        this.animationTime = 0L;
        this.hasLeaped = false;
        ((CatamountEntity)((Object)entity)).getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.interval);
    }

    private void performLeap(T entity, LivingEntity target) {
        Vec3 direction = target.position().subtract(entity.position()).normalize();
        double horizontalSpeed = 0.8;
        double verticalSpeed = 0.4;
        Vec3 leapVector = new Vec3(direction.x * horizontalSpeed, verticalSpeed, direction.z * horizontalSpeed);
        entity.setDeltaMovement(entity.getDeltaMovement().add(leapVector));
        ((CatamountEntity)((Object)entity)).hasImpulse = true;
    }

    public static interface RunTask<T> {
        public void run(ServerLevel var1, T var2, long var3);
    }

    public static interface FinishRunningTask<T> {
        public void run(ServerLevel var1, T var2, long var3);
    }
}

