/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.task;

import com.google.common.collect.ImmutableMap;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GeckoMeleeAttackTask<T extends Mob>
extends Behavior<T> {
    private final int interval;
    private final double animationTimeOfAttack;
    private long animationTime = 0L;
    private final int animationDuration;
    private final RunTask<T> runTask;
    private final FinishRunningTask<T> finishRunningTask;

    public GeckoMeleeAttackTask(RunTask<T> runTask, FinishRunningTask<T> finishRunningTask, int interval, double animationTime, double animationTimeOfAttack) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
        this.interval = interval;
        this.animationDuration = (int)animationTime;
        this.animationTimeOfAttack = animationTimeOfAttack;
        this.runTask = runTask;
        this.finishRunningTask = finishRunningTask;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T entity) {
        LivingEntity livingEntity = BrainUtils.getAttackTarget(entity);
        return BehaviorUtils.canSee(entity, (LivingEntity)livingEntity) && entity.isWithinMeleeAttackRange(livingEntity);
    }

    protected void start(ServerLevel level, T mobEntity, long gameTime) {
        mobEntity.setAggressive(true);
        LivingEntity livingEntity = BrainUtils.getAttackTarget(mobEntity);
        mobEntity.setTarget(livingEntity);
        BehaviorUtils.lookAtEntity(mobEntity, (LivingEntity)livingEntity);
        this.runTask.run(level, mobEntity, gameTime);
        this.animationTime = gameTime + (long)this.animationDuration;
    }

    protected boolean canStillUse(ServerLevel level, T entity, long gameTime) {
        return gameTime < this.animationTime;
    }

    protected void tick(ServerLevel level, T entity, long gameTime) {
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && (double)this.animationTime == (double)gameTime + this.animationTimeOfAttack) {
            LivingEntity livingEntity = BrainUtils.getAttackTarget(entity);
            entity.swing(InteractionHand.MAIN_HAND);
            entity.doHurtTarget((Entity)livingEntity);
        }
    }

    protected void stop(ServerLevel level, T entity, long gameTime) {
        entity.setAggressive(false);
        this.finishRunningTask.run(level, entity, gameTime);
        this.animationTime = 0L;
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.interval);
    }

    public static interface RunTask<T> {
        public void run(ServerLevel var1, T var2, long var3);
    }

    public static interface FinishRunningTask<T> {
        public void run(ServerLevel var1, T var2, long var3);
    }
}

