/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.events;

import dev.sterner.the_catamount.catamount_events.CatamountEventHandler;
import dev.sterner.the_catamount.catamount_events.DamagingEvents;
import dev.sterner.the_catamount.catamount_events.PassiveEvents;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.CatamountEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ModEventHandlers {
    public static void onServerTickPlayer(ServerPlayer player) {
        CatamountPlayerDataAttachment.tick(player);
        CatamountEventHandler.tick(player);
        DamagingEvents.DangerousLeavesEvent.tickDangerousLeaves(player);
    }

    public static void onServerLevelTick(ServerLevel level) {
        if (level.dimension() == Level.OVERWORLD) {
            PassiveEvents.SoulFireConversionEvent.tickConversions(level);
            PassiveEvents.AnimalStareEvent.tickFrozenAnimals(level);
            PassiveEvents.PaleAnimalsEvent.tickPaleAnimals(level);
        }
    }

    public static float onLivingDamage(LivingEntity entity, DamageSource source, float amount) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            amount = CatamountEventHandler.onPlayerDamage(player, source, amount);
        }
        return amount;
    }

    public static void onLivingDeath(LivingEntity entity, DamageSource source) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof CatamountEntity) {
            CatamountEntity catamount = (CatamountEntity)entity2;
            ServerPlayer nearestPlayer = ModEventHandlers.findNearestPlayer(entity);
            if (nearestPlayer != null) {
                int points = ModEventHandlers.calculatePointsForKill(entity, catamount.isFeedingFrenzy());
                CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)nearestPlayer);
                CatamountPlayerDataAttachment.setData((Player)nearestPlayer, data.addPoints(points));
            }
        }
    }

    private static ServerPlayer findNearestPlayer(LivingEntity entity) {
        ServerPlayer sp;
        Player player = entity.level().getNearestPlayer((Entity)entity, 64.0);
        return player instanceof ServerPlayer ? (sp = (ServerPlayer)player) : null;
    }

    private static int calculatePointsForKill(LivingEntity entity, boolean feedingFrenzy) {
        float maxHealth = entity.getMaxHealth();
        if (feedingFrenzy) {
            return (int)maxHealth;
        }
        return (int)(maxHealth / 2.0f);
    }
}

