/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.listener;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SoulConversionListener {
    public static final SoulfireConversionResourceListener LOADER = new SoulfireConversionResourceListener(new Gson(), "soul_conversion");
    public static final Map<Block, Block> CONVERSION_PAIR = new HashMap<Block, Block>();

    public static BlockState copySharedProperties(BlockState fromState, BlockState toState) {
        for (Property property : fromState.getProperties()) {
            Property targetProperty = toState.getBlock().getStateDefinition().getProperty(property.getName());
            if (targetProperty == null) continue;
            toState = SoulConversionListener.setPropertySafe(toState, targetProperty, fromState.getValue(property));
        }
        return toState;
    }

    private static <T extends Comparable<T>> BlockState setPropertySafe(BlockState state, Property<T> property, Comparable<?> value) {
        try {
            Comparable<?> castedValue = value;
            return (BlockState)state.setValue(property, castedValue);
        }
        catch (ClassCastException e) {
            return state;
        }
    }

    public static void convertBlock(Level level, BlockPos pos, Block fromBlock) {
        Map<Block, Block> conversionMap = CONVERSION_PAIR;
        if (!conversionMap.containsKey(fromBlock)) {
            return;
        }
        Block toBlock = conversionMap.get(fromBlock);
        BlockState fromState = level.getBlockState(pos);
        BlockState newState = SoulConversionListener.copySharedProperties(fromState, toBlock.defaultBlockState());
        level.setBlock(pos, newState, 3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            for (int i = 0; i < 5; ++i) {
                double offsetX = 0.5 + (random.nextDouble() - 0.5);
                double offsetY = 0.5 + (random.nextDouble() - 0.5);
                double offsetZ = 0.5 + (random.nextDouble() - 0.5);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class SoulfireConversionResourceListener
    extends SimpleJsonResourceReloadListener {
        public SoulfireConversionResourceListener(Gson gson, String directory) {
            super(gson, directory);
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
                ResourceLocation file = entry.getKey();
                JsonElement element = entry.getValue();
                if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        this.parseJson(e.getAsJsonObject(), file);
                    }
                    continue;
                }
                if (!element.isJsonObject()) continue;
                this.parseJson(element.getAsJsonObject(), file);
            }
        }

        private void parseJson(JsonObject json, ResourceLocation file) {
            String targetJson;
            String blockJson = json.has("normal") ? json.get("normal").getAsString() : null;
            String string = targetJson = json.has("soul") ? json.get("soul").getAsString() : null;
            if (blockJson != null && targetJson != null) {
                ResourceLocation fromId = ResourceLocation.tryParse((String)blockJson);
                ResourceLocation toId = ResourceLocation.tryParse((String)targetJson);
                if (fromId == null || toId == null) {
                    return;
                }
                ConversionData data = (ConversionData)((Pair)ConversionData.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(IllegalArgumentException::new)).getFirst();
                Optional fromBlock = BuiltInRegistries.BLOCK.getOptional(data.normal);
                Optional toBlock = BuiltInRegistries.BLOCK.getOptional(data.soul);
                if (fromBlock.isPresent() && toBlock.isPresent()) {
                    CONVERSION_PAIR.put((Block)fromBlock.get(), (Block)toBlock.get());
                }
            }
        }
    }

    public record ConversionData(ResourceLocation normal, ResourceLocation soul) {
        public static final Codec<ConversionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("normal").forGetter(d -> d.normal), (App)ResourceLocation.CODEC.fieldOf("soul").forGetter(d -> d.soul)).apply((Applicative)instance, ConversionData::new));
    }
}

