/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.mixin;

import dev.sterner.the_catamount.data_attachment.FrozenAnimalDataAttachment;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void the_catamount$preventFrozenTravel(Vec3 travelVector, CallbackInfo ci) {
        ServerLevel level;
        FrozenAnimalDataAttachment.Data data;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Animal && !entity.level().isClientSide && (data = FrozenAnimalDataAttachment.getData(level = (ServerLevel)entity.level())).frozenAnimals().containsKey(entity.getUUID())) {
            entity.setDeltaMovement(Vec3.ZERO);
            ci.cancel();
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    private void the_catamount$keepFrozenInPlace(CallbackInfo ci) {
        ServerLevel level;
        FrozenAnimalDataAttachment.Data data;
        FrozenAnimalDataAttachment.FrozenRecord record;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Animal && !entity.level().isClientSide && (record = (data = FrozenAnimalDataAttachment.getData(level = (ServerLevel)entity.level())).frozenAnimals().get(entity.getUUID())) != null) {
            entity.setDeltaMovement(Vec3.ZERO);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.getNavigation().stop();
                mob.setYBodyRot(record.yaw());
                mob.setYRot(record.yaw());
                mob.setYHeadRot(record.yaw());
                mob.setXRot(record.pitch());
                mob.yBodyRotO = record.yaw();
                mob.yRotO = record.yaw();
                mob.yHeadRotO = record.yaw();
                mob.xRotO = record.pitch();
            }
        }
    }

    @Inject(method={"tickHeadTurn(FF)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void the_catamount$preventFrozenHeadTurn(float yRot, float animStep, CallbackInfoReturnable<Float> cir) {
        ServerLevel level;
        FrozenAnimalDataAttachment.Data data;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Animal && !entity.level().isClientSide && (data = FrozenAnimalDataAttachment.getData(level = (ServerLevel)entity.level())).frozenAnimals().containsKey(entity.getUUID())) {
            cir.cancel();
        }
    }
}

