/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.neoforge;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.sterner.the_catamount.ClientCatamountConfig;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.client.CatamountHudOverlay;
import dev.sterner.the_catamount.client.ClientTickHandler;
import dev.sterner.the_catamount.client.StrugglingSpiritParticle;
import dev.sterner.the_catamount.client.model.DevouredModel;
import dev.sterner.the_catamount.client.model.WindEntityModel;
import dev.sterner.the_catamount.client.render.CatamountEntityRenderer;
import dev.sterner.the_catamount.client.render.DevouredRenderer;
import dev.sterner.the_catamount.client.render.LightOrbEntityRenderer;
import dev.sterner.the_catamount.client.render.SuspiciousDirtBlockEntityRenderer;
import dev.sterner.the_catamount.client.render.WindEntityRenderer;
import dev.sterner.the_catamount.registry.TCBlockEntityTypes;
import dev.sterner.the_catamount.registry.TCBlocks;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import dev.sterner.the_catamount.registry.TCParticles;
import dev.sterner.the_catamount.registry.TCShaders;
import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(value={Dist.CLIENT})
public class TheCatamountClientNeoForge {
    @SubscribeEvent
    public static void onClientSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(TCEntityTypes.CATAMOUNT, CatamountEntityRenderer::new);
        event.registerBlockEntityRenderer(TCBlockEntityTypes.SUSPICIOUS_DIRT, SuspiciousDirtBlockEntityRenderer::new);
        event.registerEntityRenderer(TCEntityTypes.DEVOURED, DevouredRenderer::new);
        event.registerEntityRenderer(TCEntityTypes.WIND, WindEntityRenderer::new);
        event.registerEntityRenderer(TCEntityTypes.LIGHT_ORB, LightOrbEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DevouredModel.LAYER, DevouredModel::createBodyLayer);
        event.registerLayerDefinition(WindEntityModel.LAYER, WindEntityModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TCParticles.SPIRIT_FACE, StrugglingSpiritParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        ClientTickHandler.onClientTick();
    }

    @SubscribeEvent
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)TCBlocks.MONSTROUS_REMAINS, (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)TCBlocks.MONSTROUS_SKULL, (RenderType)RenderType.cutout());
        });
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.HOTBAR)) {
            CatamountHudOverlay.render(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), TheCatamount.id("rendertype_entity_desaturated"), DefaultVertexFormat.NEW_ENTITY), TCShaders::setRendertypeEntityDesaturated);
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"catamounthud").then(Commands.literal((String)"toggle").executes(context -> {
            ClientCatamountConfig.toggleHud();
            boolean enabled = ClientCatamountConfig.isHudEnabled();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Catamount HUD: " + (enabled ? "ON" : "OFF"))).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            return 1;
        }))).then(Commands.literal((String)"on").executes(context -> {
            ClientCatamountConfig.setHudEnabled(true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Catamount HUD: ON").withStyle(ChatFormatting.GREEN), false);
            return 1;
        }))).then(Commands.literal((String)"off").executes(context -> {
            ClientCatamountConfig.setHudEnabled(false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Catamount HUD: OFF").withStyle(ChatFormatting.RED), false);
            return 1;
        })));
    }
}

