/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.PaleAnimalDataAttachment;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.DevouredEntity;
import dev.sterner.the_catamount.entity.WindEntity;
import dev.sterner.the_catamount.events.ModEventHandlers;
import dev.sterner.the_catamount.listener.SoulConversionListener;
import dev.sterner.the_catamount.neoforge.TCDataAttachmentsNeoForge;
import dev.sterner.the_catamount.payload.EventTriggeredPayload;
import dev.sterner.the_catamount.payload.FogEffectPayload;
import dev.sterner.the_catamount.payload.PaleAnimalSyncPayload;
import dev.sterner.the_catamount.payload.SyncCatamountPlayerDataPayload;
import dev.sterner.the_catamount.payload.SyncPaleAnimalDataPayload;
import dev.sterner.the_catamount.registry.TCBlockEntityTypes;
import dev.sterner.the_catamount.registry.TCBlocks;
import dev.sterner.the_catamount.registry.TCCommands;
import dev.sterner.the_catamount.registry.TCCreativeTabs;
import dev.sterner.the_catamount.registry.TCDataComponents;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import dev.sterner.the_catamount.registry.TCItems;
import dev.sterner.the_catamount.registry.TCSensorTypes;
import dev.sterner.the_catamount.registry.neoforge.TCParticlesNeoForge;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="the_catamount")
public class TheCatamountNeoForge {
    private final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"the_catamount");
    private final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"the_catamount");
    private final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"the_catamount");
    private final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"the_catamount");
    private final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"the_catamount");
    private final DeferredRegister<DataComponentType<?>> DATAS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"the_catamount");
    public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_catamount");
    public static final DeferredRegister<SensorType<?>> SENSORS = DeferredRegister.create((ResourceKey)Registries.SENSOR_TYPE, (String)"the_catamount");
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"the_catamount");

    public TheCatamountNeoForge(IEventBus eventBus) {
        this.CREATIVE_TABS.register("main", () -> new TCCreativeTabs().createMain());
        this.ENTITY_TYPES.register("catamount", () -> TCEntityTypes.CATAMOUNT);
        this.ENTITY_TYPES.register("devoured", () -> TCEntityTypes.DEVOURED);
        this.ENTITY_TYPES.register("wind", () -> TCEntityTypes.WIND);
        this.ENTITY_TYPES.register("light_orb", () -> TCEntityTypes.LIGHT_ORB);
        this.ITEMS.register("beast_ivory", () -> TCItems.BEAST_IVORY);
        this.ITEMS.register("white_ash", () -> TCItems.WHITE_ASH);
        this.ITEMS.register("bone_heap", () -> TCItems.BONE_HEAP);
        this.ITEMS.register("suspicious_dirt", () -> TCItems.SUSPICIOUS_DIRT);
        this.ITEMS.register("devour_petroglyph", () -> TCItems.DEVOUR_PETROGLYPH);
        this.ITEMS.register("awaken_petroglyph", () -> TCItems.AWAKEN_PETROGLYPH);
        this.ITEMS.register("lightening_petroglyph", () -> TCItems.LIGHTENING_PETROGLYPH);
        this.ITEMS.register("slain_petroglyph", () -> TCItems.SLAIN_PETROGLYPH);
        this.ITEMS.register("monstrous_remains", () -> TCItems.MONSTROUS_REMAINS);
        this.ITEMS.register("monstrous_skull", () -> TCItems.MONSTROUS_SKULL);
        this.BLOCKS.register("white_ash", () -> TCBlocks.WHITE_ASH);
        this.BLOCKS.register("bone_heap", () -> TCBlocks.BONE_HEAP);
        this.BLOCKS.register("suspicious_dirt", () -> TCBlocks.SUSPICIOUS_DIRT);
        this.BLOCKS.register("devour_petroglyph", () -> TCBlocks.DEVOUR_PETROGLYPH);
        this.BLOCKS.register("awaken_petroglyph", () -> TCBlocks.AWAKEN_PETROGLYPH);
        this.BLOCKS.register("lightening_petroglyph", () -> TCBlocks.LIGHTENING_PETROGLYPH);
        this.BLOCKS.register("slain_petroglyph", () -> TCBlocks.SLAIN_PETROGLYPH);
        this.BLOCKS.register("monstrous_remains", () -> TCBlocks.MONSTROUS_REMAINS);
        this.BLOCKS.register("monstrous_skull", () -> TCBlocks.MONSTROUS_SKULL);
        this.DATAS.register("white_ash_coated", () -> TCDataComponents.WHITE_ASH_COATED);
        this.BLOCK_ENTITY_TYPES.register("suspicious_dirt", () -> TCBlockEntityTypes.SUSPICIOUS_DIRT);
        this.BLOCK_ENTITY_TYPES.register("monstrous_remains", () -> TCBlockEntityTypes.MONSTROUS_REMAINS);
        SENSORS.register("catamount_sensor", () -> TCSensorTypes.CATAMOUNT_SENSOR);
        SERIALIZERS.register("attack_type", () -> EntityDataSerializer.forValueType(CatamountEntity.AttackType.STREAM_CODEC));
        TCDataAttachmentsNeoForge.ATTACHMENT_TYPES.register(eventBus);
        this.ENTITY_TYPES.register(eventBus);
        this.DATAS.register(eventBus);
        this.ITEMS.register(eventBus);
        this.BLOCKS.register(eventBus);
        this.BLOCK_ENTITY_TYPES.register(eventBus);
        this.CREATIVE_TABS.register(eventBus);
        MOB_EFFECTS.register(eventBus);
        SENSORS.register(eventBus);
        SERIALIZERS.register(eventBus);
        TheCatamount.init();
        TCParticlesNeoForge.init(eventBus);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(TheCatamountNeoForge::onRegisterPayloadHandlers);
        eventBus.addListener(TheCatamountNeoForge::onEntityAttribute);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TCParticlesNeoForge::assignParticles);
    }

    public static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(SyncCatamountPlayerDataPayload.ID, SyncCatamountPlayerDataPayload.STREAM_CODEC, (payload, ctx) -> payload.handleS2C());
        registrar.playToClient(PaleAnimalSyncPayload.ID, PaleAnimalSyncPayload.STREAM_CODEC, (payload, ctx) -> payload.handleS2C());
        registrar.playToClient(SyncPaleAnimalDataPayload.ID, SyncPaleAnimalDataPayload.STREAM_CODEC, (payload, ctx) -> payload.handleS2C());
        registrar.playToClient(EventTriggeredPayload.ID, EventTriggeredPayload.STREAM_CODEC, (payload, ctx) -> payload.handleS2C());
        registrar.playToClient(FogEffectPayload.ID, FogEffectPayload.STREAM_CODEC, (payload, ctx) -> payload.handleS2C());
    }

    public static void onEntityAttribute(EntityAttributeCreationEvent event) {
        event.put(TCEntityTypes.CATAMOUNT, CatamountEntity.createAttributes().build());
        event.put(TCEntityTypes.DEVOURED, DevouredEntity.createAttributes().build());
        event.put(TCEntityTypes.WIND, WindEntity.createAttributes().build());
    }

    @EventBusSubscriber(modid="the_catamount", bus=EventBusSubscriber.Bus.GAME)
    public static class GameEvents {
        @SubscribeEvent
        public static void registerListeners(AddReloadListenerEvent event) {
            TheCatamount.LOGGER.info("Registering SoulConversionListener");
            event.addListener((PreparableReloadListener)SoulConversionListener.LOADER);
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingDamageEvent.Pre event) {
            float newAmount = ModEventHandlers.onLivingDamage(event.getEntity(), event.getSource(), event.getOriginalDamage());
            event.setNewDamage(newAmount);
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            ModEventHandlers.onLivingDeath(event.getEntity(), event.getSource());
        }

        @SubscribeEvent
        public static void onCommandsRegister(RegisterCommandsEvent event) {
            TCCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onServerLevelTick(LevelTickEvent.Post event) {
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ModEventHandlers.onServerLevelTick(serverLevel);
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Level level = event.getEntity().level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)player;
                    PaleAnimalDataAttachment.Data paleData = PaleAnimalDataAttachment.getData(serverLevel);
                    PaleAnimalDataAttachment.sync(serverLevel, paleData, List.of(player2));
                }
            }
        }
    }
}

