/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.payload;

import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.client.ClientPaleAnimalTracker;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class PaleAnimalSyncPayload
implements CustomPacketPayload {
    private final CompoundTag nbt;
    public static final CustomPacketPayload.Type<PaleAnimalSyncPayload> ID = new CustomPacketPayload.Type(TheCatamount.id("sync_pale_animal"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleAnimalSyncPayload> STREAM_CODEC = CustomPacketPayload.codec(PaleAnimalSyncPayload::write, PaleAnimalSyncPayload::new);

    public PaleAnimalSyncPayload(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public PaleAnimalSyncPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public PaleAnimalSyncPayload(UUID animalUUID, long endTime, boolean remove) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("AnimalUUID", animalUUID);
        tag.putLong("EndTime", endTime);
        tag.putBoolean("Remove", remove);
        this.nbt = tag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handleS2C() {
        Minecraft client = Minecraft.getInstance();
        UUID animalUUID = this.nbt.getUUID("AnimalUUID");
        long endTime = this.nbt.getLong("EndTime");
        boolean remove = this.nbt.getBoolean("Remove");
        client.execute(() -> {
            if (remove) {
                ClientPaleAnimalTracker.removePale(animalUUID);
            } else {
                ClientPaleAnimalTracker.markPale(animalUUID, endTime);
            }
        });
    }
}

