/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.payload;

import com.mojang.serialization.DynamicOps;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class SyncCatamountPlayerDataPayload
implements CustomPacketPayload {
    private final CompoundTag nbt;
    public static final CustomPacketPayload.Type<SyncCatamountPlayerDataPayload> ID = new CustomPacketPayload.Type(TheCatamount.id("sync_catamount_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCatamountPlayerDataPayload> STREAM_CODEC = CustomPacketPayload.codec(SyncCatamountPlayerDataPayload::write, SyncCatamountPlayerDataPayload::new);

    public SyncCatamountPlayerDataPayload(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public SyncCatamountPlayerDataPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public SyncCatamountPlayerDataPayload(Player player, CatamountPlayerDataAttachment.Data data) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("Id", player.getUUID());
        CatamountPlayerDataAttachment.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data).resultOrPartial(arg_0 -> ((Logger)TheCatamount.LOGGER).error(arg_0)).ifPresent(encoded -> tag.put("catamountData", encoded));
        this.nbt = tag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handleS2C() {
        Minecraft client = Minecraft.getInstance();
        UUID id = this.nbt.getUUID("Id");
        CompoundTag dataTag = this.nbt.getCompound("catamountData");
        Optional parsed = CatamountPlayerDataAttachment.Data.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)dataTag).resultOrPartial(arg_0 -> ((Logger)TheCatamount.LOGGER).error(arg_0));
        client.execute(() -> {
            if (client.level != null) {
                Player player = client.level.getPlayerByUUID(id);
                parsed.ifPresent(data -> {
                    if (player != null) {
                        CatamountPlayerDataAttachment.setData(player, data);
                    }
                });
            }
        });
    }
}

