/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.payload;

import com.mojang.serialization.DynamicOps;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.client.ClientPaleAnimalTracker;
import dev.sterner.the_catamount.data_attachment.PaleAnimalDataAttachment;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.slf4j.Logger;

public class SyncPaleAnimalDataPayload
implements CustomPacketPayload {
    private final CompoundTag nbt;
    public static final CustomPacketPayload.Type<SyncPaleAnimalDataPayload> ID = new CustomPacketPayload.Type(TheCatamount.id("sync_pale_animal_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPaleAnimalDataPayload> STREAM_CODEC = CustomPacketPayload.codec(SyncPaleAnimalDataPayload::write, SyncPaleAnimalDataPayload::new);

    public SyncPaleAnimalDataPayload(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public SyncPaleAnimalDataPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public SyncPaleAnimalDataPayload(PaleAnimalDataAttachment.Data data) {
        CompoundTag tag = new CompoundTag();
        PaleAnimalDataAttachment.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data).resultOrPartial(arg_0 -> ((Logger)TheCatamount.LOGGER).error(arg_0)).ifPresent(encoded -> tag.put("paleAnimalData", encoded));
        this.nbt = tag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handleS2C() {
        Minecraft client = Minecraft.getInstance();
        CompoundTag dataTag = this.nbt.getCompound("paleAnimalData");
        Optional parsed = PaleAnimalDataAttachment.Data.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)dataTag).resultOrPartial(arg_0 -> ((Logger)TheCatamount.LOGGER).error(arg_0));
        client.execute(() -> {
            if (client.level != null) {
                parsed.ifPresent(data -> {
                    ClientPaleAnimalTracker.clear();
                    for (Map.Entry<UUID, Long> entry : data.paleAnimals().entrySet()) {
                        ClientPaleAnimalTracker.markPale(entry.getKey(), entry.getValue());
                    }
                });
            }
        });
    }
}

