/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.sterner.the_catamount.PlatformHelper;
import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.DamagingEvents;
import dev.sterner.the_catamount.catamount_events.DangerousEvents;
import dev.sterner.the_catamount.catamount_events.DeadlyEvents;
import dev.sterner.the_catamount.catamount_events.PassiveEvents;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.payload.FogEffectPayload;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TCCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"catamount").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"trigger").then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            DebugUsage.debugTriggerBatch(player, count);
            player.sendSystemMessage((Component)Component.literal((String)("Triggered " + count + " events")).withStyle(ChatFormatting.GREEN));
            return 1;
        })))).then(Commands.literal((String)"spawn").then(Commands.argument((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)3, (int)5)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int stage = IntegerArgumentType.getInteger((CommandContext)context, (String)"stage");
            DebugUsage.debugSpawnCatamount(player, stage);
            player.sendSystemMessage((Component)Component.literal((String)("Spawned stage " + stage + " catamount")).withStyle(ChatFormatting.RED));
            return 1;
        })))).then(Commands.literal((String)"wind").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugWind(player);
            return 1;
        }))).then(Commands.literal((String)"soul_conversion").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugSoulFireConversion(player);
            return 1;
        }))).then(Commands.literal((String)"spiritface").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugSpiritFace(player);
            return 1;
        }))).then(Commands.literal((String)"lightorb").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugLightOrb(player);
            return 1;
        }))).then(Commands.literal((String)"animalstare").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugAnimalStare(player);
            return 1;
        }))).then(Commands.literal((String)"villagersweat").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugVillagerSweat(player);
            return 1;
        }))).then(Commands.literal((String)"footsteps").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugFootsteps(player);
            return 1;
        }))).then(Commands.literal((String)"pale").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int count = DebugUsage.debugPaleAnimals(player);
            player.sendSystemMessage((Component)Component.literal((String)("Made " + count + " animals pale")).withStyle(ChatFormatting.GRAY));
            return 1;
        }))).then(Commands.literal((String)"extradamage").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugExtraDamage(player);
            return 1;
        }))).then(Commands.literal((String)"stealfood").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugStealFood(player);
            return 1;
        }))).then(Commands.literal((String)"dangerousleaves").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugDangerousLeaves(player);
            return 1;
        }))).then(Commands.literal((String)"dangerouswind").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugDangerousWind(player);
            return 1;
        }))).then(Commands.literal((String)"eyesindark").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugEyesInDark(player);
            return 1;
        }))).then(Commands.literal((String)"feedingfrenzy").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugFeedingFrenzy(player);
            return 1;
        }))).then(Commands.literal((String)"bloodparticles").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugBloodParticles(player);
            return 1;
        }))).then(Commands.literal((String)"boneheap").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugBoneHeap(player);
            return 1;
        }))).then(Commands.literal((String)"multiplewinds").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugMultipleWinds(player);
            return 1;
        }))).then(Commands.literal((String)"nightmanifestation").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugNightManifestation(player);
            return 1;
        }))).then(Commands.literal((String)"fog").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DebugUsage.debugFog(player);
            return 1;
        }))).then(Commands.literal((String)"freeze").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int count = DebugUsage.debugFreezeAnimals(player);
            player.sendSystemMessage((Component)Component.literal((String)("Froze " + count + " animals")).withStyle(ChatFormatting.AQUA));
            return 1;
        }))).then(Commands.literal((String)"setstage").then(Commands.argument((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)5)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int stage = IntegerArgumentType.getInteger((CommandContext)context, (String)"stage");
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            CatamountPlayerDataAttachment.setData((Player)player, data.withCatamountStage(stage));
            player.sendSystemMessage((Component)Component.literal((String)("Set catamount stage to " + stage)).withStyle(ChatFormatting.GOLD));
            return 1;
        })))).then(Commands.literal((String)"setpoints").then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            CatamountPlayerDataAttachment.setData((Player)player, data.withPoints(points));
            player.sendSystemMessage((Component)Component.literal((String)("Set points to " + points)).withStyle(ChatFormatting.GOLD));
            return 1;
        })))).then(Commands.literal((String)"clearcooldown").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            CatamountPlayerDataAttachment.setData((Player)player, data.withEventCooldown(0));
            player.sendSystemMessage((Component)Component.literal((String)"Cleared event cooldown").withStyle(ChatFormatting.GREEN));
            return 1;
        }))).then(Commands.literal((String)"resetdata").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            CatamountPlayerDataAttachment.setData((Player)player, new CatamountPlayerDataAttachment.Data());
            player.sendSystemMessage((Component)Component.literal((String)"Reset all catamount data").withStyle(ChatFormatting.YELLOW));
            return 1;
        }))).then(Commands.literal((String)"advance").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            boolean advanced = CatamountPlayerDataAttachment.tryAdvanceStage((Player)player);
            if (advanced) {
                CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
                player.sendSystemMessage((Component)Component.literal((String)("Advanced to stage " + data.catamountStage())).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Not enough points to advance stage").withStyle(ChatFormatting.RED));
            }
            return advanced ? 1 : 0;
        }))).then(Commands.literal((String)"listevents").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            player.sendSystemMessage((Component)Component.literal((String)"=== Available Events ===").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            player.sendSystemMessage((Component)Component.literal((String)("Passive Events: " + PassiveEvents.getAll().size())).withStyle(ChatFormatting.GREEN));
            if (data.catamountStage() >= 1) {
                player.sendSystemMessage((Component)Component.literal((String)("Damaging Events: " + DamagingEvents.getAll().size())).withStyle(ChatFormatting.YELLOW));
            }
            if (data.catamountStage() >= 2) {
                player.sendSystemMessage((Component)Component.literal((String)("Dangerous Events: " + DangerousEvents.getAll().size())).withStyle(ChatFormatting.GOLD));
            }
            if (data.catamountStage() >= 3) {
                player.sendSystemMessage((Component)Component.literal((String)("Deadly Events: " + DeadlyEvents.getAll().size())).withStyle(ChatFormatting.RED));
            }
            return 1;
        }))));
    }

    static class DebugUsage {
        DebugUsage() {
        }

        public static void debugWind(ServerPlayer player) {
            new PassiveEvents.SummonTheWindEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Summoned the wind").withStyle(ChatFormatting.AQUA));
        }

        public static void debugSoulFireConversion(ServerPlayer player) {
            new PassiveEvents.SoulFireConversionEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Soul fire conversion triggered").withStyle(ChatFormatting.AQUA));
        }

        public static void debugSpiritFace(ServerPlayer player) {
            new PassiveEvents.FaintSpiritEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Spawned spirit face").withStyle(ChatFormatting.LIGHT_PURPLE));
        }

        public static void debugLightOrb(ServerPlayer player) {
            new PassiveEvents.BallOfLightEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Spawned ball of light").withStyle(ChatFormatting.YELLOW));
        }

        public static void debugAnimalStare(ServerPlayer player) {
            new PassiveEvents.AnimalStareEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Animals are staring").withStyle(ChatFormatting.WHITE));
        }

        public static void debugVillagerSweat(ServerPlayer player) {
            new PassiveEvents.VillagerSweatEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Villagers are sweating").withStyle(ChatFormatting.GREEN));
        }

        public static void debugFootsteps(ServerPlayer player) {
            new PassiveEvents.FootstepsEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Mysterious footsteps").withStyle(ChatFormatting.GRAY));
        }

        public static int debugPaleAnimals(ServerPlayer player) {
            PassiveEvents.PaleAnimalsEvent event = new PassiveEvents.PaleAnimalsEvent();
            event.execute(player);
            List animals = player.level().getEntitiesOfClass(Animal.class, player.getBoundingBox().inflate(32.0));
            return animals.size();
        }

        public static void debugExtraDamage(ServerPlayer player) {
            new PassiveEvents.ExtraDamageEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Extra damage active for 1 minute").withStyle(ChatFormatting.GOLD));
        }

        public static void debugStealFood(ServerPlayer player) {
            new DamagingEvents.StealFoodEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Food stolen from nearby containers").withStyle(ChatFormatting.GOLD));
        }

        public static void debugDangerousLeaves(ServerPlayer player) {
            new DamagingEvents.DangerousLeavesEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Nearby leaves are now dangerous").withStyle(ChatFormatting.RED));
        }

        public static void debugDangerousWind(ServerPlayer player) {
            new DamagingEvents.DangerousWindEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Spawned dangerous wind").withStyle(ChatFormatting.RED));
        }

        public static void debugEyesInDark(ServerPlayer player) {
            new DangerousEvents.EyesInDarkEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Eyes watching from the dark").withStyle(ChatFormatting.DARK_RED));
        }

        public static void debugFeedingFrenzy(ServerPlayer player) {
            new DangerousEvents.FeedingFrenzyEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Feeding frenzy activated").withStyle(ChatFormatting.DARK_RED));
        }

        public static void debugBloodParticles(ServerPlayer player) {
            new DeadlyEvents.BloodParticlesEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Blood particles falling").withStyle(ChatFormatting.DARK_RED));
        }

        public static void debugBoneHeap(ServerPlayer player) {
            new DeadlyEvents.BoneHeapEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Bone heaps spawned").withStyle(ChatFormatting.WHITE));
        }

        public static void debugMultipleWinds(ServerPlayer player) {
            new DeadlyEvents.MultipleWindGustsEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Multiple wind gusts spawned").withStyle(ChatFormatting.AQUA));
        }

        public static void debugNightManifestation(ServerPlayer player) {
            new DeadlyEvents.NightManifestationEvent().execute(player);
            player.sendSystemMessage((Component)Component.literal((String)"Night manifestation summoned").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
        }

        public static void debugFog(ServerPlayer player) {
            ServerLevel level = player.serverLevel();
            BlockPos center = player.blockPosition();
            List nearbyPlayers = level.getEntitiesOfClass(ServerPlayer.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)center), (double)64.0, (double)64.0, (double)64.0));
            for (ServerPlayer nearbyPlayer : nearbyPlayers) {
                FogEffectPayload payload = new FogEffectPayload(Vec3.atCenterOf((Vec3i)center), 64.0f, 600);
                PlatformHelper.sendPayloadToPlayer(nearbyPlayer, payload);
            }
            player.sendSystemMessage((Component)Component.literal((String)"Fog effect applied").withStyle(ChatFormatting.DARK_GRAY));
        }

        public static int debugFreezeAnimals(ServerPlayer player) {
            PassiveEvents.AnimalStareEvent event = new PassiveEvents.AnimalStareEvent();
            event.execute(player);
            List animals = player.level().getEntitiesOfClass(Animal.class, player.getBoundingBox().inflate(32.0));
            return animals.size();
        }

        public static void debugTriggerBatch(ServerPlayer player, int count) {
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            ArrayList<CatamountEvent> validEvents = new ArrayList<CatamountEvent>();
            validEvents.addAll(PassiveEvents.getAll());
            if (data.catamountStage() >= 1) {
                validEvents.addAll(DamagingEvents.getAll());
            }
            if (data.catamountStage() >= 2) {
                validEvents.addAll(DangerousEvents.getAll());
            }
            if (data.catamountStage() >= 3) {
                validEvents.addAll(DeadlyEvents.getAll());
            }
            Collections.shuffle(validEvents);
            for (int i = 0; i < Math.min(count, validEvents.size()); ++i) {
                ((CatamountEvent)validEvents.get(i)).execute(player);
            }
        }

        public static void debugSpawnCatamount(ServerPlayer player, int stage) {
            ServerLevel level = player.serverLevel();
            BlockPos spawnPos = player.blockPosition().offset(5, 0, 5);
            CatamountEntity catamount = new CatamountEntity(TCEntityTypes.CATAMOUNT, (Level)level);
            catamount.setPos((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            catamount.setStage(stage);
            catamount.setOwnerUUID(Optional.of(player.getUUID()));
            level.addFreshEntity((Entity)catamount);
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
            CatamountPlayerDataAttachment.setData((Player)player, data.withCatamountUUID(Optional.of(catamount.getUUID())));
        }
    }
}

