/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientCatamountConfig {
    private static boolean hudEnabled = false;
    private static final List<String> recentEvents = new ArrayList<String>();
    private static final int MAX_EVENTS_DISPLAY = 5;
    private static final int EVENT_DISPLAY_TIME = 600;
    private static final Map<String, Integer> eventTimers = new HashMap<String, Integer>();

    public static boolean isHudEnabled() {
        return hudEnabled;
    }

    public static void toggleHud() {
        hudEnabled = !hudEnabled;
    }

    public static void setHudEnabled(boolean enabled) {
        hudEnabled = enabled;
    }

    public static void addEvent(String eventName) {
        if (recentEvents.size() >= 5) {
            String oldest = recentEvents.remove(0);
            eventTimers.remove(oldest);
        }
        recentEvents.add(eventName);
        eventTimers.put(eventName, 600);
    }

    public static List<String> getRecentEvents() {
        return new ArrayList<String>(recentEvents);
    }

    public static void tick() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : eventTimers.entrySet()) {
            int newTime = entry.getValue() - 1;
            if (newTime <= 0) {
                toRemove.add(entry.getKey());
                continue;
            }
            eventTimers.put(entry.getKey(), newTime);
        }
        for (String event : toRemove) {
            recentEvents.remove(event);
            eventTimers.remove(event);
        }
    }

    public static int getEventTimer(String eventName) {
        return eventTimers.getOrDefault(eventName, 0);
    }

    public static void clear() {
        recentEvents.clear();
        eventTimers.clear();
    }
}

