/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.block;

import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.registry.TCBlockEntityTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;

public class MonstrousHeadBlockEntity
extends class_2586 {
    private static final int PROXIMITY_RADIUS = 48;
    private static final int MAX_PROXIMITY_TIME = 3600;
    private final Map<UUID, Integer> playerProximityTime = new HashMap<UUID, Integer>();
    private boolean hasBeenAwakened = false;

    public MonstrousHeadBlockEntity(class_2338 pos, class_2680 blockState) {
        super(TCBlockEntityTypes.MONSTROUS_REMAINS, pos, blockState);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MonstrousHeadBlockEntity blockEntity) {
        if (level.field_9236 || blockEntity.hasBeenAwakened) {
            return;
        }
        List nearbyPlayers = level.method_18467(class_3222.class, new class_238(pos).method_1014(48.0));
        for (class_3222 player : nearbyPlayers) {
            UUID playerId = player.method_5667();
            int time = blockEntity.playerProximityTime.getOrDefault(playerId, 0) + 1;
            blockEntity.playerProximityTime.put(playerId, time);
            if (time < 3600) continue;
            blockEntity.awakenCatamount(player, (class_3218)level);
            break;
        }
        blockEntity.playerProximityTime.keySet().removeIf(uuid -> nearbyPlayers.stream().noneMatch(p -> p.method_5667().equals(uuid)));
        blockEntity.method_5431();
    }

    private void awakenCatamount(class_3222 player, class_3218 level) {
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
        if (data.catamountStage() >= 0) {
            return;
        }
        data = data.withCatamountStage(0).withStageTimer(0);
        CatamountPlayerDataAttachment.setData((class_1657)player, data);
        level.method_14199((class_2394)class_2398.field_22246, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, 50, 1.0, 1.0, 1.0, 0.05);
        level.method_8396(null, this.field_11867, class_3417.field_38067, class_3419.field_15251, 2.0f, 0.5f);
        this.hasBeenAwakened = true;
        this.method_5431();
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10556("HasBeenAwakened", this.hasBeenAwakened);
        class_2487 proximityTag = new class_2487();
        this.playerProximityTime.forEach((uuid, time) -> proximityTag.method_10569(uuid.toString(), time.intValue()));
        tag.method_10566("PlayerProximityTime", (class_2520)proximityTag);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.hasBeenAwakened = tag.method_10577("HasBeenAwakened");
        class_2487 proximityTag = tag.method_10562("PlayerProximityTime");
        this.playerProximityTime.clear();
        for (String key : proximityTag.method_10541()) {
            UUID uuid = UUID.fromString(key);
            this.playerProximityTime.put(uuid, proximityTag.method_10550(key));
        }
    }
}

