/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.block;

import dev.sterner.the_catamount.block.SuspiciousDirtBlock;
import dev.sterner.the_catamount.registry.TCBlockEntityTypes;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class SuspiciousDirtBlockEntity
extends class_2586 {
    private int brushProgress = 0;
    private long brushResetTime = 0L;
    private long coolDownEndsAtTick = 0L;
    private class_1799 storedItem = class_1799.field_8037;
    private class_2350 hitDirection = null;
    private class_5321<class_52> lootTable = null;
    private long lootTableSeed = 0L;

    public SuspiciousDirtBlockEntity(class_2338 pos, class_2680 state) {
        super(TCBlockEntityTypes.SUSPICIOUS_DIRT, pos, state);
    }

    public boolean brush(long startTick, class_1657 player, class_2350 hitDirection) {
        class_1937 class_19372;
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.brushResetTime = startTick + 40L;
        if (startTick >= this.coolDownEndsAtTick && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.coolDownEndsAtTick = startTick + 10L;
            this.unpackLootTable(player);
            int prevState = this.getCompletionState();
            ++this.brushProgress;
            if (this.brushProgress >= 10) {
                this.onBrushingCompleted(player);
                return true;
            }
            this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 2);
            int newState = this.getCompletionState();
            if (prevState != newState) {
                class_2680 newBlockState = (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(newState));
                this.field_11863.method_8652(this.field_11867, newBlockState, 3);
            }
            return false;
        }
        return false;
    }

    private void unpackLootTable(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.storedItem.method_7960()) {
                List<class_1799> list = List.of(class_1802.field_8606.method_7854(), class_1802.field_8511.method_7854(), class_1802.field_8398.method_7854());
                class_5819 random = serverLevel.method_8409();
                this.storedItem = list.get(random.method_43048(list.size() - 1));
                this.lootTable = null;
                this.method_5431();
            }
        }
    }

    private void onBrushingCompleted(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_2248 replacementBlock;
            class_3218 serverLevel = (class_3218)class_19372;
            this.dropLoot(player);
            class_2680 currentState = this.method_11010();
            this.field_11863.method_20290(3008, this.field_11867, class_2248.method_9507((class_2680)currentState));
            class_2248 class_22482 = currentState.method_26204();
            if (class_22482 instanceof SuspiciousDirtBlock) {
                SuspiciousDirtBlock graveyardBlock = (SuspiciousDirtBlock)class_22482;
                replacementBlock = graveyardBlock.turnsInto;
            } else {
                replacementBlock = class_2246.field_10124;
            }
            this.field_11863.method_8652(this.field_11867, replacementBlock.method_9564(), 3);
        }
    }

    private void dropLoot(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.unpackLootTable(player);
            if (!this.storedItem.method_7960()) {
                double entityWidth = class_1299.field_6052.method_17685();
                double posOffset = 1.0 - entityWidth;
                double halfWidth = entityWidth / 2.0;
                class_2350 dropDir = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
                class_2338 dropPos = this.field_11867.method_10079(dropDir, 1);
                double x = (double)dropPos.method_10263() + 0.5 * posOffset + halfWidth;
                double y = (double)dropPos.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
                double z = (double)dropPos.method_10260() + 0.5 * posOffset + halfWidth;
                class_1542 itemEntity = new class_1542(this.field_11863, x, y, z, this.storedItem.method_7971(serverLevel.method_8409().method_43048(21) + 10));
                itemEntity.method_18799(class_243.field_1353);
                this.field_11863.method_8649((class_1297)itemEntity);
                this.storedItem = class_1799.field_8037;
            }
        }
    }

    public void resetBrushingState() {
        if (this.field_11863 == null) {
            return;
        }
        long gameTime = this.field_11863.method_8510();
        if (this.brushProgress != 0 && gameTime >= this.brushResetTime) {
            int oldState = this.getCompletionState();
            this.brushProgress = (int)Math.max(0.0, (double)this.brushProgress - 2.0);
            int newState = this.getCompletionState();
            if (oldState != newState) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(newState)), 3);
            }
            this.brushResetTime = gameTime + 4L;
        }
        if (this.brushProgress == 0) {
            this.hitDirection = null;
            this.brushResetTime = 0L;
        } else {
            this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 2);
        }
    }

    private boolean tryLoadLootTable(class_2487 tag) {
        if (tag.method_10573("LootTable", 8)) {
            this.lootTable = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)tag.method_10558("LootTable")));
            this.lootTableSeed = tag.method_10537("LootTableSeed");
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(class_2487 tag) {
        if (this.lootTable == null) {
            return false;
        }
        tag.method_10582("LootTable", this.lootTable.method_29177().toString());
        if (this.lootTableSeed != 0L) {
            tag.method_10544("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        if (this.hitDirection != null) {
            tag.method_10569("hit_direction", this.hitDirection.ordinal());
        }
        if (!this.storedItem.method_7960()) {
            tag.method_10566("item", this.storedItem.method_57358(registries));
        }
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.storedItem = !this.tryLoadLootTable(tag) && tag.method_10545("item") ? class_1799.method_57360((class_7225.class_7874)registries, (class_2520)tag.method_10562("item")).orElse(class_1799.field_8037) : class_1799.field_8037;
        if (tag.method_10545("hit_direction")) {
            this.hitDirection = class_2350.values()[tag.method_10550("hit_direction")];
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.trySaveLootTable(tag) && !this.storedItem.method_7960()) {
            tag.method_10566("item", this.storedItem.method_57358(registries));
        }
    }

    public void setLootTable(class_5321<class_52> lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    private int getCompletionState() {
        if (this.brushProgress == 0) {
            return 0;
        }
        if (this.brushProgress < 3) {
            return 1;
        }
        if (this.brushProgress < 6) {
            return 2;
        }
        return 3;
    }

    public class_1799 getStoredItem() {
        return this.storedItem;
    }

    public class_2350 getHitDirection() {
        return this.hitDirection;
    }
}

