/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.PlatformHelper;
import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.DamagingEvents;
import dev.sterner.the_catamount.catamount_events.DangerousEvents;
import dev.sterner.the_catamount.catamount_events.DeadlyEvents;
import dev.sterner.the_catamount.catamount_events.PassiveEvents;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.payload.EventTriggeredPayload;
import dev.sterner.the_catamount.registry.TCMobEffects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8111;

public class CatamountEventHandler {
    private static final int MIN_BATCH_COOLDOWN = 3600;
    private static final int RETRY_COOLDOWN = 1200;

    public static void tick(class_3222 player) {
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
        if ((data = CatamountEventHandler.tickActiveEvents(player, data)).getEventCooldown() > 0) {
            data = data.withEventCooldown(data.getEventCooldown() - 1);
            CatamountPlayerDataAttachment.setData((class_1657)player, data);
        }
        if (data.getEventCooldown() <= 0) {
            CatamountEventHandler.tryTriggerBatch(player, data);
        }
    }

    private static CatamountPlayerDataAttachment.Data tickActiveEvents(class_3222 player, CatamountPlayerDataAttachment.Data data) {
        boolean needsUpdate = false;
        if (data.getExtraDamageTimer() > 0) {
            data = data.withExtraDamageTimer(data.getExtraDamageTimer() - 1);
            needsUpdate = true;
        }
        if (data.getSoulFireTimer() > 0) {
            data = data.withSoulFireTimer(data.getSoulFireTimer() - 1);
            needsUpdate = true;
        }
        if (data.getFeedingFrenzyCooldown() > 0) {
            data = data.withFeedingFrenzyCooldown(data.getFeedingFrenzyCooldown() - 1);
            needsUpdate = true;
        }
        if (needsUpdate) {
            CatamountPlayerDataAttachment.setData((class_1657)player, data);
        }
        return data;
    }

    private static void tryTriggerBatch(class_3222 player, CatamountPlayerDataAttachment.Data data) {
        class_5819 random = player.method_59922();
        int coinFlips = CatamountEventHandler.getTimeOfDayCoins(player);
        boolean passedCoinFlip = false;
        for (int i = 0; i < coinFlips; ++i) {
            if (!random.method_43056()) continue;
            passedCoinFlip = true;
            break;
        }
        if (!passedCoinFlip) {
            CatamountPlayerDataAttachment.setData((class_1657)player, data.withEventCooldown(1200));
            return;
        }
        double moonBatchChance = CatamountEventHandler.getMoonPhaseBatchChance(player.method_37908());
        if (random.method_43058() > moonBatchChance) {
            CatamountPlayerDataAttachment.setData((class_1657)player, data.withEventCooldown(1200));
            return;
        }
        int eventsInBatch = CatamountEventHandler.determineBatchSize(player.method_37908(), random);
        CatamountEventHandler.executeEventBatch(player, data, eventsInBatch);
        CatamountPlayerDataAttachment.setData((class_1657)player, data.withEventCooldown(3600));
    }

    private static int getTimeOfDayCoins(class_3222 player) {
        long dayTime = player.method_37908().method_8532() % 24000L;
        if (dayTime >= 1000L && dayTime < 13000L) {
            return 1;
        }
        if (dayTime >= 13000L && dayTime < 23000L) {
            return 3;
        }
        return 2;
    }

    private static double getMoonPhaseBatchChance(class_1937 level) {
        int moonPhase = level.method_30273();
        return switch (moonPhase) {
            case 0 -> 0.9;
            case 1, 7 -> 0.75;
            case 2, 6 -> 0.5;
            case 3, 5 -> 0.33;
            case 4 -> 0.2;
            default -> 0.5;
        };
    }

    private static int determineBatchSize(class_1937 level, class_5819 random) {
        int moonPhase = level.method_30273();
        double roll = random.method_43058();
        return switch (moonPhase) {
            case 0 -> {
                if (roll < 0.05) {
                    yield 1;
                }
                if (roll < 0.34) {
                    yield 2;
                }
                yield 3;
            }
            case 1, 7 -> {
                if (roll < 0.1) {
                    yield 1;
                }
                if (roll < 0.5) {
                    yield 2;
                }
                yield 3;
            }
            case 2, 6 -> {
                if (roll < 0.33) {
                    yield 1;
                }
                if (roll < 0.67) {
                    yield 2;
                }
                yield 3;
            }
            case 3, 5 -> {
                if (roll < 0.66) {
                    yield 1;
                }
                yield 2;
            }
            case 4 -> {
                if (roll < 0.75) {
                    yield 1;
                }
                yield 2;
            }
            default -> 1;
        };
    }

    private static void executeEventBatch(class_3222 player, CatamountPlayerDataAttachment.Data data, int count) {
        List<CatamountEvent> validEvents = CatamountEventHandler.getValidEventsForPlayer(player, data);
        if (validEvents.isEmpty()) {
            return;
        }
        Collections.shuffle(validEvents, new Random(player.method_59922().method_43055()));
        for (int i = 0; i < Math.min(count, validEvents.size()); ++i) {
            CatamountEvent event = validEvents.get(i);
            event.execute(player);
            String eventName = CatamountEventHandler.getEventName(event);
            EventTriggeredPayload payload = new EventTriggeredPayload(eventName);
            PlatformHelper.sendPayloadToPlayer(player, payload);
        }
    }

    private static String getEventName(CatamountEvent event) {
        String className = event.getClass().getSimpleName();
        return className.replace("Event", "").replaceAll("([A-Z])", " $1").trim();
    }

    private static List<CatamountEvent> getValidEventsForPlayer(class_3222 player, CatamountPlayerDataAttachment.Data data) {
        ArrayList<CatamountEvent> events = new ArrayList<CatamountEvent>();
        int stage = data.catamountStage();
        events.addAll(PassiveEvents.getAll());
        if (stage >= 1 && CatamountEventHandler.isValidBiomeForDamaging(player)) {
            events.addAll(DamagingEvents.getAll());
        }
        if (stage >= 2 && CatamountEventHandler.isValidBiomeForDamaging(player)) {
            events.addAll(DangerousEvents.getAll());
        }
        if (stage >= 3 && CatamountEventHandler.isValidBiomeForDamaging(player)) {
            events.addAll(DeadlyEvents.getAll());
        }
        return events;
    }

    private static boolean isValidBiomeForDamaging(class_3222 player) {
        class_5321 biomeKey = player.method_37908().method_23753(player.method_24515()).method_40230().orElse(null);
        if (biomeKey == null) {
            return false;
        }
        String biomePath = biomeKey.method_29177().method_12832();
        return !biomePath.contains("ocean") && !biomePath.contains("cave") && !biomePath.contains("desert") && !biomePath.contains("badlands");
    }

    public static float onPlayerDamage(class_3222 player, class_1282 source, float amount) {
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
        if (data.getExtraDamageTimer() > 0 && CatamountEventHandler.isQualifyingDamageSource(source)) {
            float extraDamage = 1.0f + player.method_59922().method_43057();
            int points = (int)extraDamage;
            CatamountPlayerDataAttachment.setData((class_1657)player, data.addPoints(points));
            if (player.method_59922().method_43057() < 0.3f) {
                CatamountEventHandler.applyBleeding(player);
            }
            return amount + extraDamage;
        }
        return amount;
    }

    private static boolean isQualifyingDamageSource(class_1282 source) {
        return source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42360) || source.method_49708(class_8111.field_42345);
    }

    private static void applyBleeding(class_3222 player) {
        player.method_6092(new class_1293(TCMobEffects.BLEEDING, 80, 0));
    }
}

