/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.data_attachment.DangerousLeavesDataAttachment;
import dev.sterner.the_catamount.entity.WindEntity;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3924;
import net.minecraft.class_9334;

public class DamagingEvents {
    public static List<CatamountEvent> getAll() {
        return List.of(new StealFoodEvent(), new DangerousLeavesEvent(), new DangerousWindEvent());
    }

    public static class StealFoodEvent
    extends CatamountEvent {
        public StealFoodEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(class_3222 player) {
            int stolenCount = 0;
            class_2338 searchCenter = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            block0: for (class_2338 pos : class_2338.method_10097((class_2338)searchCenter.method_10069(-16, -8, -16), (class_2338)searchCenter.method_10069(16, 8, 16))) {
                class_2609 furnace;
                class_1799 result;
                if (stolenCount >= 5) break;
                class_2586 blockEntity = level.method_8321(pos);
                if (blockEntity instanceof class_2609 && (result = (furnace = (class_2609)blockEntity).method_5438(2)).method_57826(class_9334.field_50075)) {
                    int toSteal = Math.min(result.method_7947(), 5 - stolenCount);
                    result.method_7934(toSteal);
                    stolenCount += toSteal;
                }
                if (!(blockEntity instanceof class_3924)) continue;
                class_3924 campfire = (class_3924)blockEntity;
                for (int i = 0; i < 4; ++i) {
                    class_1799 item = (class_1799)campfire.method_17505().get(i);
                    if (item.method_7960()) continue;
                    campfire.method_17505().set(i, (Object)class_1799.field_8037);
                    if (++stolenCount >= 5) continue block0;
                }
            }
            List items = level.method_18467(class_1542.class, new class_238(searchCenter).method_1014(16.0));
            for (class_1542 itemEntity : items) {
                if (stolenCount >= 5) break;
                class_1799 stack = itemEntity.method_6983();
                if (!stack.method_57826(class_9334.field_50075)) continue;
                int toSteal = Math.min(stack.method_7947(), 5 - stolenCount);
                stack.method_7934(toSteal);
                stolenCount += toSteal;
                if (!stack.method_7960()) continue;
                itemEntity.method_31472();
            }
            if (stolenCount > 0) {
                this.addPoints(player, stolenCount);
                level.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15256, 0.5f, 0.8f);
            }
        }
    }

    public static class DangerousLeavesEvent
    extends CatamountEvent {
        private static final int DURATION = 600;

        public DangerousLeavesEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 center = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            ArrayList<class_2338> dangerousLeaves = new ArrayList<class_2338>();
            for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-10, -5, -10), (class_2338)center.method_10069(10, 5, 10))) {
                class_2680 state = level.method_8320(pos);
                if (!state.method_26164(class_3481.field_15503) || state.method_31709()) continue;
                dangerousLeaves.add(pos.method_10062());
            }
            if (!dangerousLeaves.isEmpty()) {
                DangerousLeavesDataAttachment.Data data = DangerousLeavesDataAttachment.getData(level);
                long endTime = level.method_8510() + 600L;
                for (class_2338 pos : dangerousLeaves) {
                    data = data.withDangerousLeaf(pos, endTime);
                }
                DangerousLeavesDataAttachment.setData(level, data);
                level.method_14199((class_2394)class_2398.field_22248, (double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5, 20, 5.0, 2.0, 5.0, 0.05);
                level.method_8396(null, center, (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15256, 0.8f, 0.6f);
            }
        }

        public static void tickDangerousLeaves(class_3222 player) {
            class_2338 playerPos = player.method_24515();
            class_3218 level = player.method_51469();
            DangerousLeavesDataAttachment.Data data = DangerousLeavesDataAttachment.getData(level);
            long currentTime = level.method_8510();
            for (class_2338 pos : new ArrayList<class_2338>(data.dangerousLeaves().keySet())) {
                class_2680 state;
                long endTime = data.dangerousLeaves().get(pos);
                if (currentTime >= endTime) {
                    data = data.withoutDangerousLeaf(pos);
                    continue;
                }
                if (!(playerPos.method_10262((class_2382)pos) <= 9.0) || !(state = level.method_8320(pos)).method_26164(class_3481.field_15503) || state.method_31709()) continue;
                if (level.method_8510() % 40L != 0L) break;
                float damage = 1.0f + player.method_59922().method_43057();
                if (player.method_6032() > damage) {
                    player.method_5643(level.method_48963().method_48831(), damage);
                    CatamountPlayerDataAttachment.Data pData = CatamountPlayerDataAttachment.getData((class_1657)player);
                    CatamountPlayerDataAttachment.setData((class_1657)player, pData.addPoints((int)damage));
                } else {
                    player.method_5643(level.method_48963().method_48831(), 0.0f);
                }
                level.method_14199((class_2394)class_2398.field_11209, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
                break;
            }
            DangerousLeavesDataAttachment.setData(level, data);
        }
    }

    public static class DangerousWindEvent
    extends CatamountEvent {
        public DangerousWindEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 location = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            WindEntity wind = new WindEntity(TCEntityTypes.WIND, (class_1937)level);
            wind.method_5814((double)location.method_10263() + 0.5, location.method_10264(), (double)location.method_10260() + 0.5);
            wind.method_19540(true);
            wind.setTargetPlayer(player.method_5667());
            level.method_8649((class_1297)wind);
            level.method_8396(null, location, (class_3414)class_3417.field_49049.comp_349(), class_3419.field_15251, 1.0f, 0.8f);
        }
    }
}

