/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.DamagingEvents;
import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1429;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class DangerousEvents {
    public static List<CatamountEvent> getAll() {
        ArrayList<CatamountEvent> events = new ArrayList<CatamountEvent>();
        events.addAll(DamagingEvents.getAll());
        events.add(new EyesInDarkEvent());
        events.add(new FeedingFrenzyEvent());
        return events;
    }

    public static class EyesInDarkEvent
    extends CatamountEvent {
        public EyesInDarkEvent() {
            super(EventType.DANGEROUS, true, 2);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 darkSpot = this.findDarkLocation(player);
            if (darkSpot == null) {
                return;
            }
            player.method_51469().method_14199((class_2394)class_2398.field_11207, (double)darkSpot.method_10263() + 0.5, (double)darkSpot.method_10264() + 1.5, (double)darkSpot.method_10260() + 0.5, 2, 0.1, 0.1, 0.1, 0.0);
        }

        private class_2338 findDarkLocation(class_3222 player) {
            class_3218 level = player.method_51469();
            class_5819 random = player.method_59922();
            for (int i = 0; i < 10; ++i) {
                class_2338 pos = player.method_24515().method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
                if (level.method_22339(pos) >= 7) continue;
                return pos;
            }
            return null;
        }
    }

    public static class FeedingFrenzyEvent
    extends CatamountEvent {
        private final int HARD_COOLDOWN = 12000;

        public FeedingFrenzyEvent() {
            super(EventType.DANGEROUS, true, 1);
        }

        @Override
        public boolean canExecute(class_3222 player) {
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
            return data.deathCooldownTimer() <= 0 && data.catamountUUID().isEmpty() && data.getFeedingFrenzyCooldown() <= 0;
        }

        @Override
        public void execute(class_3222 player) {
            class_3218 level = player.method_51469();
            class_2338 spawnPos = this.findValidSpawnPos(level, player.method_24515());
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
            CatamountEntity catamount = new CatamountEntity(TCEntityTypes.CATAMOUNT, (class_1937)level);
            catamount.method_5814((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            catamount.setStage(data.catamountStage());
            catamount.setOwnerUUID(Optional.of(player.method_5667()));
            catamount.setFeedingFrenzy(true);
            catamount.setFrenzyKillsRemaining(5);
            level.method_8649((class_1297)catamount);
            this.makeEntitiesPanic(player, 32.0);
            level.method_14199((class_2394)class_2398.field_22246, (double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 1), (double)spawnPos.method_10260() + 0.5, 30, 1.0, 1.0, 1.0, 0.05);
            level.method_8396(null, spawnPos, class_3417.field_38067, class_3419.field_15251, 2.0f, 0.7f);
            data = data.withFeedingFrenzyCooldown(12000);
            CatamountPlayerDataAttachment.setData((class_1657)player, data);
        }

        private class_2338 findValidSpawnPos(class_3218 level, class_2338 center) {
            class_5819 random = level.method_8409();
            for (int i = 0; i < 20; ++i) {
                class_2338 pos = center.method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
                while (level.method_8320(pos).method_26215() && pos.method_10264() > level.method_31607()) {
                    pos = pos.method_10074();
                }
                if (!level.method_18026(class_238.method_30048((class_243)class_243.method_24953((class_2382)(pos = pos.method_10084())), (double)1.0, (double)2.0, (double)1.0))) continue;
                return pos;
            }
            return center;
        }

        private void makeEntitiesPanic(class_3222 player, double radius) {
            List mobs = player.method_37908().method_18467(class_1314.class, player.method_5829().method_1014(radius));
            for (class_1314 mob : mobs) {
                if (!(mob instanceof class_1429) && !(mob instanceof class_1646)) continue;
                mob.method_5942().method_6340();
            }
        }
    }
}

