/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.PlatformHelper;
import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.DangerousEvents;
import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.WindEntity;
import dev.sterner.the_catamount.payload.FogEffectPayload;
import dev.sterner.the_catamount.registry.TCBlocks;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class DeadlyEvents {
    public static List<CatamountEvent> getAll() {
        ArrayList<CatamountEvent> events = new ArrayList<CatamountEvent>();
        events.addAll(DangerousEvents.getAll());
        events.add(new BloodParticlesEvent());
        events.add(new BoneHeapEvent());
        events.add(new MultipleWindGustsEvent());
        events.add(new NightManifestationEvent());
        return events;
    }

    public static class BloodParticlesEvent
    extends CatamountEvent {
        public BloodParticlesEvent() {
            super(EventType.DEADLY, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 location = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            level.method_14199((class_2394)class_2398.field_22248, (double)location.method_10263() + 0.5, (double)(location.method_10264() + 3), (double)location.method_10260() + 0.5, 30, 1.0, 1.0, 1.0, 0.1);
            level.method_8396(null, location, class_3417.field_17614, class_3419.field_15256, 1.0f, 0.8f);
        }
    }

    public static class BoneHeapEvent
    extends CatamountEvent {
        public BoneHeapEvent() {
            super(EventType.DEADLY, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_3218 level = player.method_51469();
            class_5819 random = player.method_59922();
            int count = 1 + random.method_43048(5);
            for (int i = 0; i < count; ++i) {
                class_2338 pos = this.getEventLocation(player);
                while (level.method_8320(pos).method_26215() && pos.method_10264() > level.method_31607()) {
                    pos = pos.method_10074();
                }
                pos = pos.method_10084();
                level.method_8652(pos, TCBlocks.BONE_HEAP.method_9564(), 3);
            }
        }
    }

    public static class MultipleWindGustsEvent
    extends CatamountEvent {
        public MultipleWindGustsEvent() {
            super(EventType.DEADLY, false);
        }

        @Override
        public boolean canExecute(class_3222 player) {
            long dayTime = player.method_37908().method_8532() % 24000L;
            return dayTime >= 13000L && dayTime < 23000L;
        }

        @Override
        public void execute(class_3222 player) {
            class_5819 random = player.method_59922();
            int gustCount = 3 + random.method_43048(3);
            class_3218 level = player.method_51469();
            for (int i = 0; i < gustCount; ++i) {
                class_2338 gustPos = player.method_24515().method_10069(random.method_43048(16) - 8, random.method_43048(4) - 2, random.method_43048(16) - 8);
                WindEntity wind = new WindEntity(TCEntityTypes.WIND, (class_1937)level);
                wind.method_5814((double)gustPos.method_10263() + 0.5, gustPos.method_10264(), (double)gustPos.method_10260() + 0.5);
                wind.method_19540(true);
                wind.setTargetPlayer(player.method_5667());
                level.method_8649((class_1297)wind);
            }
            level.method_8396(null, player.method_24515(), (class_3414)class_3417.field_49049.comp_349(), class_3419.field_15251, 1.5f, 0.7f);
        }
    }

    public static class NightManifestationEvent
    extends CatamountEvent {
        public NightManifestationEvent() {
            super(EventType.DEADLY, true, 3);
        }

        @Override
        public boolean canExecute(class_3222 player) {
            long dayTime = player.method_37908().method_8532() % 24000L;
            if (dayTime < 13000L || dayTime >= 23000L) {
                return false;
            }
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
            if (data.deathCooldownTimer() > 0 || data.catamountUUID().isPresent()) {
                return false;
            }
            int moonPhase = player.method_37908().method_30273();
            double chance = moonPhase == 0 ? 0.3 : 0.1;
            return player.method_59922().method_43058() < chance;
        }

        @Override
        public void execute(class_3222 player) {
            class_3218 level = player.method_51469();
            class_2338 spawnPos = this.findValidSpawnPos(level, player.method_24515());
            CatamountEntity catamount = new CatamountEntity(TCEntityTypes.CATAMOUNT, (class_1937)level);
            catamount.method_5814((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            catamount.setStage(Math.max(3, CatamountPlayerDataAttachment.getData((class_1657)player).catamountStage()));
            catamount.setOwnerUUID(Optional.of(player.method_5667()));
            catamount.setFullyManifested(true);
            level.method_8649((class_1297)catamount);
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
            CatamountPlayerDataAttachment.setData((class_1657)player, data.withCatamountUUID(Optional.of(catamount.method_5667())));
            this.applyFogEffect(player, level, spawnPos);
            level.method_14199((class_2394)class_2398.field_22246, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264() + 1.5, (double)spawnPos.method_10260() + 0.5, 50, 2.0, 1.0, 2.0, 0.05);
            level.method_14199((class_2394)class_2398.field_11237, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, 20, 1.0, 0.5, 1.0, 0.02);
            level.method_8396(null, spawnPos, class_3417.field_38075, class_3419.field_15251, 2.0f, 0.7f);
        }

        private class_2338 findValidSpawnPos(class_3218 level, class_2338 center) {
            class_5819 random = level.method_8409();
            for (int i = 0; i < 20; ++i) {
                class_2338 pos = center.method_10069(random.method_43048(40) - 20, random.method_43048(6) - 3, random.method_43048(40) - 20);
                while (level.method_8320(pos).method_26215() && pos.method_10264() > level.method_31607()) {
                    pos = pos.method_10074();
                }
                if (level.method_22339(pos = pos.method_10084()) >= 7 || !level.method_18026(class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)2.0, (double)3.0, (double)2.0))) continue;
                return pos;
            }
            return center.method_10069(10, 0, 10);
        }

        private void applyFogEffect(class_3222 player, class_3218 level, class_2338 center) {
            List nearbyPlayers = level.method_18467(class_3222.class, class_238.method_30048((class_243)class_243.method_24953((class_2382)center), (double)64.0, (double)64.0, (double)64.0));
            for (class_3222 nearbyPlayer : nearbyPlayers) {
                FogEffectPayload payload = new FogEffectPayload(class_243.method_24953((class_2382)center), 64.0f, 600);
                PlatformHelper.sendPayloadToPlayer(nearbyPlayer, payload);
                nearbyPlayer.method_6092(new class_1293(class_1294.field_38092, 600, 0, false, false));
            }
        }
    }
}

