/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.data_attachment.FrozenAnimalDataAttachment;
import dev.sterner.the_catamount.data_attachment.PaleAnimalDataAttachment;
import dev.sterner.the_catamount.data_attachment.SoulConversionDataAttachment;
import dev.sterner.the_catamount.entity.LightOrbEntity;
import dev.sterner.the_catamount.entity.WindEntity;
import dev.sterner.the_catamount.listener.SoulConversionListener;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import dev.sterner.the_catamount.registry.TCParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class PassiveEvents {
    public static List<CatamountEvent> getAll() {
        return List.of(new SummonTheWindEvent(), new SoulFireConversionEvent(), new FaintSpiritEvent(), new BallOfLightEvent(), new AnimalStareEvent(), new VillagerSweatEvent(), new FootstepsEvent(), new PaleAnimalsEvent(), new ExtraDamageEvent());
    }

    public static class SummonTheWindEvent
    extends CatamountEvent {
        public SummonTheWindEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 location = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            WindEntity wind = new WindEntity(TCEntityTypes.WIND, (class_1937)level);
            wind.method_5814((double)location.method_10263() + 0.5, location.method_10264(), (double)location.method_10260() + 0.5);
            wind.method_19540(false);
            level.method_8649((class_1297)wind);
            level.method_8396(null, location, class_3417.field_47194, class_3419.field_15256, 0.6f, 1.0f);
        }
    }

    public static class SoulFireConversionEvent
    extends CatamountEvent {
        public SoulFireConversionEvent() {
            super(EventType.PASSIVE, false);
        }

        public static void tickConversions(class_3218 level) {
            if (level.method_27983() != class_1937.field_25179) {
                return;
            }
            SoulConversionDataAttachment.Data data = SoulConversionDataAttachment.getData(level);
            if (data.activeConversions().isEmpty()) {
                return;
            }
            long currentTime = level.method_8510();
            boolean changed = false;
            for (Map.Entry<class_2338, SoulConversionDataAttachment.ConversionRecord> entry : new ArrayList<Map.Entry<class_2338, SoulConversionDataAttachment.ConversionRecord>>(data.activeConversions().entrySet())) {
                class_2248 expectedSoulBlock;
                class_2338 pos = entry.getKey();
                SoulConversionDataAttachment.ConversionRecord record = entry.getValue();
                if (currentTime < record.endTime()) continue;
                class_2680 currentState = level.method_8320(pos);
                class_2248 currentBlock = currentState.method_26204();
                if (currentBlock == (expectedSoulBlock = SoulConversionListener.CONVERSION_PAIR.get(record.originalState().method_26204()))) {
                    if (record.originalState().method_26204() instanceof class_3922 && record.extraData() != null) {
                        SoulFireConversionEvent.restoreCampfire(level, pos, record);
                    } else {
                        level.method_8652(pos, record.originalState(), 3);
                    }
                    class_5819 random = level.method_8409();
                    for (int i = 0; i < 3; ++i) {
                        level.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 0.5 + (random.method_43058() - 0.5) * 0.5, (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                data = data.withoutConversion(pos);
                changed = true;
            }
            if (changed) {
                SoulConversionDataAttachment.setData(level, data);
            }
        }

        private static void restoreCampfire(class_3218 level, class_2338 pos, SoulConversionDataAttachment.ConversionRecord record) {
            class_2586 soulCampfireEntity = level.method_8321(pos);
            class_2371 currentItems = class_2371.method_10211();
            if (soulCampfireEntity instanceof class_3924) {
                class_3924 soulCampfire = (class_3924)soulCampfireEntity;
                for (int i = 0; i < soulCampfire.method_17505().size(); ++i) {
                    class_1799 item = (class_1799)soulCampfire.method_17505().get(i);
                    if (item.method_7960()) continue;
                    currentItems.add((Object)item.method_7972());
                }
            }
            level.method_8652(pos, record.originalState(), 3);
            class_2586 newBlockEntity = level.method_8321(pos);
            if (newBlockEntity instanceof class_3924) {
                class_3924 campfire = (class_3924)newBlockEntity;
                if (record.extraData() != null) {
                    campfire.method_11014(record.extraData(), (class_7225.class_7874)level.method_30349());
                }
                for (int i = 0; i < Math.min(currentItems.size(), campfire.method_17505().size()); ++i) {
                    class_1799 item = (class_1799)currentItems.get(i);
                    if (item.method_7960() || campfire.method_17503(null, item, 1)) continue;
                    class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)item);
                }
                campfire.method_5431();
            }
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 center = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            class_5819 random = player.method_59922();
            int duration = (10 + random.method_43048(41)) * 20;
            long endTime = level.method_8510() + (long)duration;
            boolean foundAny = false;
            SoulConversionDataAttachment.Data data = SoulConversionDataAttachment.getData(level);
            for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-10, -10, -10), (class_2338)center.method_10069(10, 10, 10))) {
                class_2680 state = level.method_8320(pos);
                class_2248 block = state.method_26204();
                if (!SoulConversionListener.CONVERSION_PAIR.containsKey(block)) continue;
                class_2338 immutablePos = pos.method_10062();
                if (block instanceof class_3922) {
                    if (!((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) continue;
                    class_2586 blockEntity = level.method_8321(pos);
                    if (blockEntity instanceof class_3924) {
                        class_3924 campfire = (class_3924)blockEntity;
                        data = this.handleCampfireConversion(level, immutablePos, state, campfire, endTime, data);
                        foundAny = true;
                        continue;
                    }
                }
                SoulConversionDataAttachment.ConversionRecord record = new SoulConversionDataAttachment.ConversionRecord(state, endTime);
                data = data.withConversion(immutablePos, record);
                SoulConversionDataAttachment.setData(level, data);
                SoulConversionListener.convertBlock((class_1937)level, immutablePos, block);
            }
            if (foundAny) {
                SoulConversionDataAttachment.setData(level, data);
                level.method_8396(null, center, (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15256, 0.8f, 0.8f);
            }
        }

        private SoulConversionDataAttachment.Data handleCampfireConversion(class_3218 level, class_2338 pos, class_2680 state, class_3924 campfire, long endTime, SoulConversionDataAttachment.Data data) {
            class_2371 items = class_2371.method_10211();
            for (int i = 0; i < campfire.method_17505().size(); ++i) {
                class_1799 item = (class_1799)campfire.method_17505().get(i);
                if (item.method_7960()) continue;
                items.add((Object)item.method_7972());
            }
            class_2487 campfireData = new class_2487();
            campfire.method_11007(campfireData, (class_7225.class_7874)level.method_30349());
            SoulConversionDataAttachment.ConversionRecord record = new SoulConversionDataAttachment.ConversionRecord(state, endTime, campfireData);
            data = data.withConversion(pos, record);
            class_2248 targetBlock = SoulConversionListener.CONVERSION_PAIR.get(state.method_26204());
            if (targetBlock != null) {
                class_2680 newState = SoulConversionListener.copySharedProperties(state, targetBlock.method_9564());
                level.method_8652(pos, newState, 3);
                class_2586 newBlockEntity = level.method_8321(pos);
                if (newBlockEntity instanceof class_3924) {
                    class_3924 soulCampfire = (class_3924)newBlockEntity;
                    for (int i = 0; i < Math.min(items.size(), soulCampfire.method_17505().size()); ++i) {
                        class_1799 item = (class_1799)items.get(i);
                        if (item.method_7960() || soulCampfire.method_17503(null, item, 1)) continue;
                        class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)item);
                    }
                }
                for (int i = 0; i < 5; ++i) {
                    double offsetX = 0.5 + (level.field_9229.method_43058() - 0.5);
                    double offsetY = 0.5 + (level.field_9229.method_43058() - 0.5);
                    double offsetZ = 0.5 + (level.field_9229.method_43058() - 0.5);
                    level.method_14199((class_2394)class_2398.field_22246, (double)pos.method_10263() + offsetX, (double)pos.method_10264() + offsetY, (double)pos.method_10260() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return data;
        }
    }

    public static class FaintSpiritEvent
    extends CatamountEvent {
        public FaintSpiritEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 location = this.getEventLocation(player);
            class_3218 level = player.method_51469();
            class_2338 surfacePos = this.findValidSurface(level, location);
            if (surfacePos == null) {
                surfacePos = location;
            }
            class_2350 facing = this.findFacingDirection(level, surfacePos);
            class_243 particlePos = class_243.method_24953((class_2382)surfacePos).method_1031((double)facing.method_10148() * 0.6, 0.0, (double)facing.method_10165() * 0.6);
            level.method_14199((class_2394)TCParticles.SPIRIT_FACE, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            level.method_8396(null, surfacePos, (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15256, 0.3f, 0.5f);
        }

        private class_2338 findValidSurface(class_3218 level, class_2338 center) {
            class_5819 random = level.method_8409();
            for (int i = 0; i < 10; ++i) {
                class_2338 pos = center.method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
                if (!level.method_8320(pos).method_26216((class_1922)level, pos)) continue;
                return pos;
            }
            return null;
        }

        private class_2350 findFacingDirection(class_3218 level, class_2338 pos) {
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                if (!level.method_8320(pos.method_10093(dir)).method_26215()) continue;
                return dir;
            }
            return class_2350.field_11043;
        }
    }

    public static class BallOfLightEvent
    extends CatamountEvent {
        public BallOfLightEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 location = this.getEventLocation(player).method_10086(20);
            class_3218 level = player.method_51469();
            LightOrbEntity orb = new LightOrbEntity(TCEntityTypes.LIGHT_ORB, (class_1937)level);
            orb.method_5814((double)location.method_10263() + 0.5, location.method_10264(), (double)location.method_10260() + 0.5);
            level.method_8649((class_1297)orb);
        }
    }

    public static class AnimalStareEvent
    extends CatamountEvent {
        private static final int FREEZE_DURATION = 100;

        public AnimalStareEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            List<class_1429> animals = this.findNearbyEntities(player, class_1429.class, 32.0);
            if (animals.isEmpty()) {
                return;
            }
            class_3218 level = player.method_51469();
            float yaw = player.method_59922().method_43057() * 360.0f;
            long endTime = level.method_8510() + 100L;
            FrozenAnimalDataAttachment.Data data = FrozenAnimalDataAttachment.getData(level);
            for (class_1429 animal : animals) {
                animal.method_36456(yaw);
                animal.method_5847(yaw);
                animal.method_5636(yaw);
                animal.method_36457(0.0f);
                animal.field_5982 = yaw;
                animal.field_6259 = yaw;
                animal.field_6220 = yaw;
                animal.field_6004 = 0.0f;
                animal.method_5942().method_6340();
                animal.method_18799(class_243.field_1353);
                data = data.withFrozenAnimal(animal.method_5667(), endTime, yaw, 0.0f);
                level.method_14199((class_2394)class_2398.field_28013, animal.method_23317(), animal.method_23318() + (double)(animal.method_17682() / 2.0f), animal.method_23321(), 10, 0.3, 0.3, 0.3, 0.01);
            }
            FrozenAnimalDataAttachment.setData(level, data);
            level.method_8396(null, player.method_24515(), class_3417.field_15081, class_3419.field_15256, 0.5f, 1.5f);
        }

        public static void tickFrozenAnimals(class_3218 level) {
            FrozenAnimalDataAttachment.Data data = FrozenAnimalDataAttachment.getData(level);
            long currentTime = level.method_8510();
            boolean changed = false;
            for (UUID uuid : new ArrayList<UUID>(data.frozenAnimals().keySet())) {
                class_1429 animal;
                class_1297 entity;
                FrozenAnimalDataAttachment.FrozenRecord record = data.frozenAnimals().get(uuid);
                if (currentTime >= record.endTime()) {
                    data = data.withoutFrozenAnimal(uuid);
                    changed = true;
                    entity = level.method_14190(uuid);
                    if (!(entity instanceof class_1429)) continue;
                    animal = (class_1429)entity;
                    level.method_14199((class_2394)class_2398.field_11203, animal.method_23317(), animal.method_23318() + (double)(animal.method_17682() / 2.0f), animal.method_23321(), 5, 0.2, 0.2, 0.2, 0.02);
                    continue;
                }
                entity = level.method_14190(uuid);
                if (!(entity instanceof class_1429)) continue;
                animal = (class_1429)entity;
                animal.method_5942().method_6340();
                animal.method_18799(class_243.field_1353);
                animal.method_36456(record.yaw());
                animal.method_5847(record.yaw());
                animal.method_5636(record.yaw());
                animal.method_36457(record.pitch());
                animal.field_5982 = record.yaw();
                animal.field_6259 = record.yaw();
                animal.field_6220 = record.yaw();
                animal.field_6004 = record.pitch();
                if (currentTime % 20L != 0L) continue;
                level.method_14199((class_2394)class_2398.field_28013, animal.method_23317(), animal.method_23318() + (double)(animal.method_17682() / 2.0f), animal.method_23321(), 2, 0.2, 0.2, 0.2, 0.01);
            }
            if (changed) {
                FrozenAnimalDataAttachment.setData(level, data);
            }
        }
    }

    public static class VillagerSweatEvent
    extends CatamountEvent {
        public VillagerSweatEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            List<class_1646> villagers = this.findNearbyEntities(player, class_1646.class, 32.0);
            for (class_1646 villager : villagers) {
                player.method_51469().method_14199((class_2394)class_2398.field_11202, villager.method_23317(), villager.method_23318() + 2.0, villager.method_23321(), 3, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    public static class FootstepsEvent
    extends CatamountEvent {
        public FootstepsEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            class_2338 nearbyPos = player.method_24515().method_10069(player.method_59922().method_43048(10) - 5, 0, player.method_59922().method_43048(10) - 5);
            class_2680 groundBlock = player.method_51469().method_8320(nearbyPos.method_10074());
            class_2498 soundType = groundBlock.method_26231();
            player.method_51469().method_8396(null, nearbyPos, soundType.method_10594(), class_3419.field_15256, 0.5f, 1.0f);
        }
    }

    public static class PaleAnimalsEvent
    extends CatamountEvent {
        private static final int DURATION = 200;

        public PaleAnimalsEvent() {
            super(EventType.PASSIVE, false);
        }

        @Override
        public void execute(class_3222 player) {
            List<class_1429> animals = this.findNearbyEntities(player, class_1429.class, 32.0);
            class_3218 level = player.method_51469();
            if (animals.isEmpty()) {
                return;
            }
            long endTime = level.method_8510() + 200L;
            PaleAnimalDataAttachment.Data data = PaleAnimalDataAttachment.getData(level);
            for (class_1429 animal : animals) {
                data = data.withPaleAnimal(animal.method_5667(), endTime);
                animal.method_5643(player.method_48923().method_48831(), 0.0f);
                level.method_14199((class_2394)class_2398.field_46911, animal.method_23317(), animal.method_23318() + (double)(animal.method_17682() / 2.0f), animal.method_23321(), 5, 0.3, 0.3, 0.3, 0.01);
            }
            PaleAnimalDataAttachment.setData(level, data);
            PaleAnimalDataAttachment.syncToTrackingPlayers(level, data, (class_1297)player);
        }

        public static void tickPaleAnimals(class_3218 level) {
            PaleAnimalDataAttachment.Data data = PaleAnimalDataAttachment.getData(level);
            long currentTime = level.method_8510();
            boolean changed = false;
            for (UUID uuid : new ArrayList<UUID>(data.paleAnimals().keySet())) {
                long endTime = data.paleAnimals().get(uuid);
                if (currentTime < endTime) continue;
                data = data.withoutPaleAnimal(uuid);
                changed = true;
            }
            if (changed) {
                PaleAnimalDataAttachment.setData(level, data);
                PaleAnimalDataAttachment.syncToAll(level, data);
            }
        }
    }

    public static class ExtraDamageEvent
    extends CatamountEvent {
        public ExtraDamageEvent() {
            super(EventType.PASSIVE, true, 2);
        }

        @Override
        public void execute(class_3222 player) {
            CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)player);
            CatamountPlayerDataAttachment.setData((class_1657)player, data.withExtraDamageTimer(1200));
        }
    }
}

