/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.client;

import dev.sterner.the_catamount.ClientCatamountConfig;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class CatamountHudOverlay {
    public static void render(class_332 graphics, class_9779 partialTick) {
        String cooldown;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1690.field_1842) {
            return;
        }
        if (!ClientCatamountConfig.isHudEnabled()) {
            return;
        }
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)mc.field_1724);
        if (data.catamountStage() < 0) {
            return;
        }
        int screenWidth = mc.method_22683().method_4486();
        int x = screenWidth - 120;
        int y = 10;
        int baseHeight = 60;
        int eventHeight = ClientCatamountConfig.getRecentEvents().size() * 12;
        int totalHeight = baseHeight + eventHeight;
        graphics.method_25294(x - 5, y - 5, x + 115, y + totalHeight, Integer.MIN_VALUE);
        graphics.method_25303(mc.field_1772, "Stage: " + data.catamountStage(), x, y, 0xFFFFFF);
        graphics.method_25303(mc.field_1772, "Points: " + data.points(), x, y + 12, 0xFFAA00);
        int nextStagePoints = CatamountHudOverlay.getNextStageRequirement(data.catamountStage());
        if (nextStagePoints > 0) {
            graphics.method_25303(mc.field_1772, "Next: " + nextStagePoints, x, y + 24, 0x888888);
        }
        int yOffset = 36;
        if (data.getEventCooldown() > 0) {
            cooldown = CatamountHudOverlay.formatTime(data.getEventCooldown());
            graphics.method_25303(mc.field_1772, "Event: " + cooldown, x, y + yOffset, 0xFF5555);
            yOffset += 12;
        } else if (data.getEventCooldown() == 0 && data.catamountStage() >= 0) {
            graphics.method_25303(mc.field_1772, "Event: READY", x, y + yOffset, 0x55FF55);
            yOffset += 12;
        }
        if (data.getExtraDamageTimer() > 0) {
            String timer = CatamountHudOverlay.formatTime(data.getExtraDamageTimer());
            graphics.method_25303(mc.field_1772, "Extra Dmg: " + timer, x, y + yOffset, 0xFF0000);
            yOffset += 12;
        }
        if (data.deathCooldownTimer() > 0) {
            cooldown = CatamountHudOverlay.formatTime(data.deathCooldownTimer());
            graphics.method_25303(mc.field_1772, "Death: " + cooldown, x, y + yOffset, 0x555555);
            yOffset += 12;
        }
        if (!ClientCatamountConfig.getRecentEvents().isEmpty()) {
            graphics.method_25303(mc.field_1772, "Recent Events:", x, y + (yOffset += 6), 0xFFFFFF);
            yOffset += 12;
            for (String event : ClientCatamountConfig.getRecentEvents()) {
                int timer = ClientCatamountConfig.getEventTimer(event);
                float alpha = Math.min(1.0f, (float)timer / 20.0f);
                int alphaInt = (int)(alpha * 255.0f);
                int color = alphaInt << 24 | 0xFFAA;
                graphics.method_25303(mc.field_1772, "\u2022 " + event, x + 2, y + yOffset, color);
                yOffset += 12;
            }
        }
    }

    private static int getNextStageRequirement(int currentStage) {
        return switch (currentStage) {
            case 0 -> 0;
            case 1 -> 20;
            case 2 -> 50;
            case 3 -> 100;
            case 4 -> 200;
            default -> -1;
        };
    }

    private static String formatTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        seconds %= 60;
        if (minutes > 0) {
            return String.format("%d:%02d", minutes, seconds);
        }
        return seconds + "s";
    }
}

