/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.client;

import net.minecraft.class_243;
import net.minecraft.class_310;

public class ClientFogEffectTracker {
    private static long fogEndTime = 0L;
    private static long fogStartTime = 0L;
    private static class_243 fogCenter = class_243.field_1353;
    private static float fogRadius = 64.0f;
    private static final int FADE_IN_TIME = 100;
    private static final int FADE_OUT_TIME = 100;

    public static void setFogEffect(class_243 center, float radius, int durationTicks) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        fogCenter = center;
        fogRadius = radius;
        fogStartTime = class_310.method_1551().field_1687.method_8510();
        fogEndTime = fogStartTime + (long)durationTicks;
    }

    public static void clearFog() {
        fogEndTime = 0L;
        fogStartTime = 0L;
    }

    public static boolean hasFogEffect() {
        if (class_310.method_1551().field_1687 == null) {
            return false;
        }
        return class_310.method_1551().field_1687.method_8510() < fogEndTime;
    }

    public static float getFogTransition() {
        if (!ClientFogEffectTracker.hasFogEffect() || class_310.method_1551().field_1687 == null) {
            return 0.0f;
        }
        long currentTime = class_310.method_1551().field_1687.method_8510();
        long elapsed = currentTime - fogStartTime;
        long remaining = fogEndTime - currentTime;
        if (elapsed < 100L) {
            return (float)elapsed / 100.0f;
        }
        if (remaining < 100L) {
            return (float)remaining / 100.0f;
        }
        return 1.0f;
    }

    public static float getFogDensity(class_243 playerPos) {
        if (!ClientFogEffectTracker.hasFogEffect()) {
            return 0.0f;
        }
        double distance = playerPos.method_1022(fogCenter);
        if (distance > (double)fogRadius) {
            return 0.0f;
        }
        float transition = ClientFogEffectTracker.getFogTransition();
        float density = 1.0f - (float)(distance / (double)fogRadius);
        return Math.min(1.0f, density * 0.8f * transition);
    }

    public static float getSkyDarkness(class_243 playerPos) {
        if (!ClientFogEffectTracker.hasFogEffect()) {
            return 0.0f;
        }
        double distance = playerPos.method_1022(fogCenter);
        if (distance > (double)fogRadius) {
            return 0.0f;
        }
        float transition = ClientFogEffectTracker.getFogTransition();
        float darkness = 1.0f - (float)(distance / (double)fogRadius);
        return Math.min(0.85f, darkness * transition);
    }

    public static void tick() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        long currentTime = class_310.method_1551().field_1687.method_8510();
        if (currentTime >= fogEndTime) {
            fogEndTime = 0L;
            fogStartTime = 0L;
        }
    }
}

