/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.SmoothCatamountMoveControl;
import dev.sterner.the_catamount.entity.brain.CatamountBrain;
import dev.sterner.the_catamount.registry.TCDataComponents;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1429;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3988;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CatamountEntity
extends class_1314
implements GeoEntity {
    private static final class_2940<Integer> STAGE = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> ANIMALS_CONSUMED = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HUMANOIDS_CONSUMED = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FEEDING_FRENZY = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FRENZY_KILLS_REMAINING = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FULLY_MANIFESTED = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_CROUCHED = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_ATTACKING = class_2945.method_12791(CatamountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<AttackType> ATTACK_TYPE = class_2945.method_12791(CatamountEntity.class, TheCatamount.ATTACK_TYPE);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation IDLE_CROUCHED = RawAnimation.begin().thenLoop("idle_crouched");
    protected static final RawAnimation MOVEMENT = RawAnimation.begin().thenLoop("movement");
    protected static final RawAnimation MOVEMENT_QUAD = RawAnimation.begin().thenLoop("movement_quad");
    protected static final RawAnimation RUNNING = RawAnimation.begin().thenLoop("running");
    protected static final RawAnimation POUNCE = RawAnimation.begin().thenPlay("pounce");
    protected static final RawAnimation ATTACK_CLAW_LEFT = RawAnimation.begin().thenPlay("attack_claw_left");
    protected static final RawAnimation ATTACK_CLAW_LEFT_CROUCHED = RawAnimation.begin().thenPlay("attack_claw_left_crouched");
    protected static final RawAnimation ATTACK_CLAW_RIGHT_CROUCHED = RawAnimation.begin().thenPlay("attack_claw_right_crouched");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CatamountEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new SmoothCatamountMoveControl((class_1308)this, 10, 1.0f);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23725, 0.0).method_26868(class_5134.field_23718, 0.5);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STAGE, (Object)3);
        builder.method_56912(OWNER_UUID, Optional.empty());
        builder.method_56912(ANIMALS_CONSUMED, (Object)0);
        builder.method_56912(HUMANOIDS_CONSUMED, (Object)0);
        builder.method_56912(FEEDING_FRENZY, (Object)false);
        builder.method_56912(FRENZY_KILLS_REMAINING, (Object)0);
        builder.method_56912(FULLY_MANIFESTED, (Object)false);
        builder.method_56912(IS_CROUCHED, (Object)false);
        builder.method_56912(IS_ATTACKING, (Object)false);
        builder.method_56912(ATTACK_TYPE, (Object)AttackType.NONE);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_6011.method_12778(IS_ATTACKING, (Object)attacking);
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("catamountBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15405("catamountActivityUpdate");
        CatamountBrain.updateActivity(this);
        this.method_37908().method_16107().method_15407();
    }

    @NotNull
    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CatamountBrain.makeBrain(this, dynamic);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_4095.class_5303<CatamountEntity> method_28306() {
        return class_4095.method_28311(CatamountBrain.MEMORIES, CatamountBrain.SENSORS);
    }

    @NotNull
    public class_4095<CatamountEntity> method_18868() {
        return super.method_18868();
    }

    public void method_5773() {
        long dayTime;
        super.method_5773();
        if (!this.method_37908().field_9236 && this.isFullyManifested() && ((dayTime = this.method_37908().method_8532() % 24000L) >= 23000L || dayTime < 1000L)) {
            this.despawnIntoWind();
        }
    }

    public boolean isActuallyMoving(CatamountEntity entity) {
        class_243 m = entity.method_18798();
        return m.method_37268() > 1.0E-4;
    }

    private void despawnIntoWind() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            CatamountPlayerDataAttachment.Data data;
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 30, 0.5, 0.5, 0.5, 0.1);
            serverLevel.method_8396(null, this.method_24515(), class_3417.field_47199, class_3419.field_15251, 1.0f, 1.0f);
            class_3222 owner = this.getOwnerPlayer();
            if (owner != null && (data = CatamountPlayerDataAttachment.getData((class_1657)owner)).catamountUUID().isPresent() && data.catamountUUID().get().equals(this.method_5667())) {
                CatamountPlayerDataAttachment.setData((class_1657)owner, data.withCatamountUUID(Optional.empty()));
            }
        }
        this.method_31472();
    }

    public void updateDynamicAttributes() {
        double baseHP = switch (this.getStage()) {
            case 3 -> 50.0;
            case 4 -> 150.0;
            case 5 -> 300.0;
            default -> 50.0;
        };
        double hp = baseHP + (double)(this.getAnimalsConsumed() * (this.getStage() >= 4 ? 5 : 3)) + (double)(this.getHumanoidsConsumed() * (this.getStage() >= 4 ? 10 : 5));
        if (this.getStage() == 5) {
            hp = Math.min(hp, 500.0);
        }
        this.method_5996(class_5134.field_23716).method_6192(hp);
        if ((double)this.method_6032() > hp) {
            this.method_6033((float)hp);
        }
        int prevStage = this.getStage();
    }

    private void updateAttributesForStage(int stage) {
        switch (stage) {
            case 3: {
                this.method_5996(class_5134.field_23721).method_6192(5.0);
                this.method_5996(class_5134.field_23724).method_6192(0.0);
                this.method_5996(class_5134.field_23725).method_6192(0.0);
                this.method_5996(class_5134.field_23718).method_6192(0.5);
                break;
            }
            case 4: {
                this.method_5996(class_5134.field_23721).method_6192(8.0);
                this.method_5996(class_5134.field_23724).method_6192(5.0);
                this.method_5996(class_5134.field_23725).method_6192(5.0);
                this.method_5996(class_5134.field_23718).method_6192(0.75);
                break;
            }
            case 5: {
                this.method_5996(class_5134.field_23721).method_6192(10.0);
                this.method_5996(class_5134.field_23724).method_6192(10.0);
                this.method_5996(class_5134.field_23725).method_6192(10.0);
                this.method_5996(class_5134.field_23718).method_6192(1.0);
            }
        }
        this.updateDynamicAttributes();
    }

    public boolean method_5643(class_1282 source, float amount) {
        float resistance;
        if (this.isWhiteAshWeapon(source)) {
            return super.method_5643(source, amount *= 1.5f);
        }
        if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42342) || this.getStage() == 5 && (source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42337))) {
            if (source.method_49708(class_8111.field_42342) || source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42338)) {
                this.teleportOut();
            }
            return false;
        }
        switch (this.getStage()) {
            case 3: {
                float f = 0.8f;
                break;
            }
            case 4: {
                float f = 0.6f;
                break;
            }
            case 5: {
                float f = 0.4f;
                break;
            }
            default: {
                float f = resistance = 1.0f;
            }
        }
        if (!this.isWhiteAshWeapon(source)) {
            amount *= resistance;
        }
        return super.method_5643(source, amount);
    }

    private void teleportOut() {
        if (this.method_37908().field_9236) {
            return;
        }
        class_5819 random = this.method_59922();
        class_2338 currentPos = this.method_24515();
        class_1937 level = this.method_37908();
        int MAX_ATTEMPTS = 16;
        int MAX_HORIZONTAL_DISTANCE = 12;
        int MAX_VERTICAL_DISTANCE = 8;
        for (int attempt = 0; attempt < 16; ++attempt) {
            int dx = random.method_39332(-12, 12);
            int dy = random.method_39332(-8, 8);
            int dz = random.method_39332(-12, 12);
            class_2338 targetPos = currentPos.method_10069(dx, dy, dz);
            while (targetPos.method_10264() > level.method_31607() && !level.method_8320(targetPos.method_10074()).method_51367()) {
                targetPos = targetPos.method_10074();
            }
            class_238 checkBox = this.method_5829().method_989((double)targetPos.method_10263() + 0.5 - this.method_23317(), (double)targetPos.method_10264() - this.method_23318(), (double)targetPos.method_10260() + 0.5 - this.method_23321());
            if (!level.method_8587((class_1297)this, checkBox) || !level.method_8320(targetPos.method_10074()).method_51367()) continue;
            this.method_5859((double)targetPos.method_10263() + 0.5, targetPos.method_10264() + 1, (double)targetPos.method_10260() + 0.5);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_22246, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 20, 0.3, 0.5, 0.3, 0.02);
                serverLevel.method_8396(null, this.method_24515(), class_3417.field_14879, class_3419.field_15251, 1.0f, 0.8f + random.method_43057() * 0.4f);
            }
            return;
        }
        class_243 fallback = this.method_19538().method_1031((random.method_43058() - 0.5) * 4.0, 0.0, (random.method_43058() - 0.5) * 4.0);
        this.method_5859(fallback.field_1352, fallback.field_1351, fallback.field_1350);
    }

    private boolean isWhiteAshWeapon(class_1282 source) {
        class_1309 living;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_6047().method_57826(TCDataComponents.WHITE_ASH_COATED)) {
            return Boolean.TRUE.equals(living.method_6047().method_57824(TCDataComponents.WHITE_ASH_COATED));
        }
        return false;
    }

    public int getAnimalsConsumed() {
        return (Integer)this.field_6011.method_12789(ANIMALS_CONSUMED);
    }

    public int getHumanoidsConsumed() {
        return (Integer)this.field_6011.method_12789(HUMANOIDS_CONSUMED);
    }

    public void setAnimalsConsumed(int consumed) {
        this.field_6011.method_12778(ANIMALS_CONSUMED, (Object)consumed);
    }

    public void increaseAnimalsConsumed() {
        this.setAnimalsConsumed(this.getAnimalsConsumed() + 1);
    }

    public void setHumanoidsConsumed(int consumed) {
        this.field_6011.method_12778(HUMANOIDS_CONSUMED, (Object)consumed);
    }

    public void increaseHumanoidsConsumed() {
        this.setHumanoidsConsumed(this.getHumanoidsConsumed() + 1);
    }

    public int getStage() {
        return (Integer)this.field_6011.method_12789(STAGE);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_6011.method_12789(OWNER_UUID);
    }

    public void setStage(int stage) {
        this.field_6011.method_12778(STAGE, (Object)stage);
    }

    public void setOwnerUUID(Optional<UUID> ownerUUID) {
        this.field_6011.method_12778(OWNER_UUID, ownerUUID);
    }

    public boolean isFeedingFrenzy() {
        return (Boolean)this.field_6011.method_12789(FEEDING_FRENZY);
    }

    public void setFeedingFrenzy(boolean frenzy) {
        this.field_6011.method_12778(FEEDING_FRENZY, (Object)frenzy);
    }

    public int getFrenzyKillsRemaining() {
        return (Integer)this.field_6011.method_12789(FRENZY_KILLS_REMAINING);
    }

    public void setFrenzyKillsRemaining(int remaining) {
        this.field_6011.method_12778(FRENZY_KILLS_REMAINING, (Object)remaining);
    }

    public boolean isFullyManifested() {
        return (Boolean)this.field_6011.method_12789(FULLY_MANIFESTED);
    }

    public void setFullyManifested(boolean manifested) {
        this.field_6011.method_12778(FULLY_MANIFESTED, (Object)manifested);
    }

    public boolean isCrouched() {
        return (Boolean)this.field_6011.method_12789(IS_CROUCHED);
    }

    public void setCrouched(boolean crouched) {
        this.field_6011.method_12778(IS_CROUCHED, (Object)crouched);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Stage", this.getStage());
        compound.method_10569("AnimalsConsumed", this.getAnimalsConsumed());
        compound.method_10569("HumanoidsConsumed", this.getHumanoidsConsumed());
        compound.method_10556("FeedingFrenzy", this.isFeedingFrenzy());
        compound.method_10569("FrenzyKillsRemaining", this.getFrenzyKillsRemaining());
        compound.method_10556("FullyManifested", this.isFullyManifested());
        compound.method_10556("IsCrouched", this.isCrouched());
        if (this.getOwnerUUID().isPresent()) {
            compound.method_25927("OwnerUUID", this.getOwnerUUID().get());
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setStage(compound.method_10550("Stage"));
        if (compound.method_25928("OwnerUUID")) {
            this.setOwnerUUID(Optional.of(compound.method_25926("OwnerUUID")));
        } else {
            this.setOwnerUUID(Optional.empty());
        }
        this.setAnimalsConsumed(compound.method_10550("AnimalsConsumed"));
        this.setHumanoidsConsumed(compound.method_10550("HumanoidsConsumed"));
        this.setFeedingFrenzy(compound.method_10577("FeedingFrenzy"));
        this.setFrenzyKillsRemaining(compound.method_10550("FrenzyKillsRemaining"));
        this.setFullyManifested(compound.method_10577("FullyManifested"));
        this.setCrouched(compound.method_10577("IsCrouched"));
        this.updateAttributesForStage(this.getStage());
    }

    public void method_6078(class_1282 source) {
        CatamountPlayerDataAttachment.Data data;
        class_3222 owner;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            CatamountPlayerDataAttachment.tellDeath(player, this);
        }
        if ((owner = this.getOwnerPlayer()) != null && (data = CatamountPlayerDataAttachment.getData((class_1657)owner)).catamountUUID().isPresent() && data.catamountUUID().get().equals(this.method_5667())) {
            CatamountPlayerDataAttachment.setData((class_1657)owner, data.withCatamountUUID(Optional.empty()));
        }
        super.method_6078(source);
    }

    public boolean method_6121(class_1297 target) {
        boolean hurt = super.method_6121(target);
        if (hurt && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            boolean isPounce = this.field_6011.method_12789(ATTACK_TYPE) == AttackType.POUNCE;
            this.triggerAttackAnimation(living, isPounce);
            if (this.isFeedingFrenzy() && living.method_6032() <= 0.0f) {
                this.onFrenzyKill(living);
            }
        }
        return hurt;
    }

    private void onFrenzyKill(class_1309 victim) {
        class_1937 class_19372;
        if (this.method_37908().field_9236) {
            return;
        }
        int killsLeft = this.getFrenzyKillsRemaining();
        if (killsLeft <= 0) {
            return;
        }
        class_3222 owner = this.getOwnerPlayer();
        if (owner == null) {
            return;
        }
        int points = (int)victim.method_6063();
        if (victim instanceof class_1429) {
            this.increaseAnimalsConsumed();
        } else if (victim instanceof class_1646 || victim instanceof class_3988) {
            this.increaseHumanoidsConsumed();
        }
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((class_1657)owner);
        CatamountPlayerDataAttachment.setData((class_1657)owner, data.addPoints(points));
        this.setFrenzyKillsRemaining(killsLeft - 1);
        if (this.getFrenzyKillsRemaining() <= 0) {
            this.exitFrenzyMode();
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_22248, victim.method_23317(), victim.method_23318() + (double)(victim.method_17682() / 2.0f), victim.method_23321(), 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    @Nullable
    private class_3222 getOwnerPlayer() {
        class_3218 serverLevel;
        class_1297 entity;
        if (this.getOwnerUUID().isEmpty()) {
            return null;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (entity = (serverLevel = (class_3218)class_19372).method_14190(this.getOwnerUUID().get())) instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return player;
        }
        return null;
    }

    private void exitFrenzyMode() {
        this.setFeedingFrenzy(false);
        this.setFrenzyKillsRemaining(0);
        this.method_37908().method_8396(null, this.method_24515(), (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15251, 1.0f, 0.8f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movement", 5, this::movementController));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 0, this::attackController));
    }

    protected <E extends CatamountEntity> PlayState movementController(AnimationState<E> event) {
        if (((Boolean)this.field_6011.method_12789(IS_ATTACKING)).booleanValue()) {
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving((CatamountEntity)event.getAnimatable())) {
            double speed = this.method_18798().method_37267();
            if (this.isCrouched()) {
                if (speed > 0.12) {
                    return event.setAndContinue(RUNNING);
                }
                return event.setAndContinue(MOVEMENT_QUAD);
            }
            return event.setAndContinue(MOVEMENT);
        }
        if (this.isCrouched()) {
            return event.setAndContinue(IDLE_CROUCHED);
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends CatamountEntity> PlayState attackController(AnimationState<E> event) {
        if (!this.isAttacking()) {
            this.field_6011.method_12778(ATTACK_TYPE, (Object)AttackType.NONE);
            return PlayState.STOP;
        }
        if (this.field_6011.method_12789(ATTACK_TYPE) == AttackType.NONE) {
            return PlayState.STOP;
        }
        return switch (((AttackType)((Object)this.field_6011.method_12789(ATTACK_TYPE))).ordinal()) {
            case 1 -> event.setAndContinue(POUNCE);
            case 2 -> {
                if (this.isCrouched()) {
                    yield event.setAndContinue(ATTACK_CLAW_LEFT_CROUCHED);
                }
                yield event.setAndContinue(ATTACK_CLAW_LEFT);
            }
            case 3 -> event.setAndContinue(ATTACK_CLAW_RIGHT_CROUCHED);
            default -> PlayState.STOP;
        };
    }

    public void triggerAttackAnimation(class_1309 target, boolean isPounce) {
        this.setAttacking(true);
        if (isPounce) {
            this.field_6011.method_12778(ATTACK_TYPE, (Object)AttackType.POUNCE);
        } else if (this.isCrouched()) {
            this.field_6011.method_12778(ATTACK_TYPE, (Object)(this.field_6011.method_12789(ATTACK_TYPE) == AttackType.CLAW_LEFT ? AttackType.CLAW_RIGHT : AttackType.CLAW_LEFT));
        } else {
            this.field_6011.method_12778(ATTACK_TYPE, (Object)AttackType.CLAW_LEFT);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum AttackType implements class_3542
    {
        NONE,
        POUNCE,
        CLAW_LEFT,
        CLAW_RIGHT;

        public static Codec<AttackType> CODEC;
        public static final class_9139<class_9129, AttackType> STREAM_CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(AttackType::values);
            STREAM_CODEC = class_9139.method_56437((buf, value) -> buf.method_10814(value.method_15434()), buf -> AttackType.valueOf(buf.method_19772().toUpperCase(Locale.ROOT)));
        }
    }
}

