/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import dev.sterner.the_catamount.entity.task.CatamountPounceTask;
import dev.sterner.the_catamount.entity.task.CatamountSmoothLookAtTask;
import dev.sterner.the_catamount.entity.task.GeckoMeleeAttackTask;
import dev.sterner.the_catamount.registry.TCSensorTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_3988;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;

public class CatamountBrain {
    public static final List<class_4149<? extends class_4148<? super CatamountEntity>>> SENSORS = List.of(class_4149.field_18467, class_4149.field_18466, class_4149.field_18469, TCSensorTypes.CATAMOUNT_SENSOR);
    public static final List<class_4140<?>> MEMORIES = List.of(class_4140.field_18441, class_4140.field_18442, class_4140.field_18444, class_4140.field_22354, class_4140.field_25360, class_4140.field_18446, class_4140.field_18445, class_4140.field_19293, class_4140.field_18449, class_4140.field_18452, class_4140.field_22333, class_4140.field_22355, class_4140.field_22475, class_4140.field_30243, class_4140.field_22357);

    public static class_4095<?> makeBrain(CatamountEntity catamount, Dynamic<?> dynamic) {
        class_4095.class_5303 profile = class_4095.method_28311(MEMORIES, SENSORS);
        class_4095 brain = profile.method_28335(dynamic);
        CatamountBrain.addCoreActivities((class_4095<CatamountEntity>)brain);
        CatamountBrain.addIdleActivities((class_4095<CatamountEntity>)brain);
        CatamountBrain.addFightActivities(catamount, (class_4095<CatamountEntity>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addFightActivities(CatamountEntity catamount, class_4095<CatamountEntity> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47139(entity -> !CatamountBrain.isPreferredAttackTarget(catamount, entity), BrainUtils::setTargetInvalid, (boolean)false), (Object)((Object)new CatamountSmoothLookAtTask()), (Object)class_4822.method_47094((float)1.2f), new CatamountPounceTask<CatamountEntity>((level, entity, time) -> entity.setAttacking(true), (level, entity, time) -> entity.setAttacking(false), 40, 20, 10.0), new GeckoMeleeAttackTask<CatamountEntity>((level, entity, time) -> entity.setAttacking(true), (level, entity, time) -> entity.setAttacking(false), 20, 14.0, 7.0)), class_4140.field_22355);
    }

    private static void addIdleActivities(class_4095<CatamountEntity> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4824.method_47119(CatamountBrain::findNearestValidTarget), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4120.method_47104((float)0.6f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1), (Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2)))));
    }

    private static void addCoreActivities(class_4095<CatamountEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.6f), (Object)new class_4110(45, 90), (Object)new class_4112()));
    }

    public static void updateActivity(CatamountEntity catamount) {
        class_4095<CatamountEntity> brain = catamount.method_18868();
        CatamountBrain.updateCrouchState(catamount);
        class_4168 currentActivity = brain.method_24538().orElse(null);
        class_4168 desiredActivity = CatamountBrain.getDesiredActivity(catamount);
        if (currentActivity != desiredActivity) {
            brain.method_24526(desiredActivity);
        }
    }

    private static void updateCrouchState(CatamountEntity catamount) {
        Optional<? extends class_1309> target = CatamountBrain.getAttackTarget(catamount);
        if (target.isPresent()) {
            class_1309 entity = target.get();
            double distance = catamount.method_5858((class_1297)entity);
            boolean shouldCrouch = entity instanceof class_1657 && distance < 64.0 || (double)entity.method_17682() < 2.0 && distance < 36.0;
            catamount.setCrouched(shouldCrouch);
        } else {
            double speed = catamount.method_18798().method_37267();
            if (speed < 0.1) {
                catamount.setCrouched(false);
            }
        }
    }

    private static class_4168 getDesiredActivity(CatamountEntity catamount) {
        if (catamount.method_18868().method_18896(class_4140.field_22355)) {
            return class_4168.field_22396;
        }
        return class_4168.field_18595;
    }

    private static boolean isPreferredAttackTarget(CatamountEntity catamount, class_1309 target) {
        return CatamountBrain.getAttackTarget(catamount).filter(preferredTarget -> preferredTarget == target).isPresent();
    }

    private static Optional<? extends class_1309> getAttackTarget(CatamountEntity catamount) {
        Optional attackTarget = catamount.method_18868().method_18904(class_4140.field_22355);
        if (attackTarget.isPresent()) {
            return attackTarget;
        }
        return catamount.method_18868().method_18904(class_4140.field_30243);
    }

    private static Optional<? extends class_1309> findNearestValidTarget(CatamountEntity catamount) {
        class_4095<CatamountEntity> brain = catamount.method_18868();
        Optional currentTarget = brain.method_18904(class_4140.field_22355);
        if (currentTarget.isPresent() && CatamountBrain.isTargetStillValid(catamount, (class_1309)currentTarget.get())) {
            return currentTarget;
        }
        Optional nearestAttackable = brain.method_18904(class_4140.field_30243);
        if (nearestAttackable.isPresent() && CatamountBrain.isTargetStillValid(catamount, (class_1309)nearestAttackable.get())) {
            return nearestAttackable;
        }
        return brain.method_18904(class_4140.field_18442).flatMap(entities -> entities.method_38975(entity -> {
            class_1309 living;
            return entity instanceof class_1309 && CatamountBrain.isValidPrey(living = entity) && !CatamountBrain.isOwner(catamount, living) && catamount.method_6057((class_1297)living);
        }));
    }

    private static boolean isTargetStillValid(CatamountEntity catamount, class_1309 target) {
        return target.method_5805() && catamount.method_5858((class_1297)target) < 1024.0 && CatamountBrain.isValidPrey(target) && !CatamountBrain.isOwner(catamount, target);
    }

    public static boolean isValidPrey(class_1309 entity) {
        return entity instanceof class_1429 || entity instanceof class_3988 || entity instanceof class_1657;
    }

    private static boolean isOwner(CatamountEntity catamount, class_1309 entity) {
        if (catamount.isFeedingFrenzy()) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return catamount.getOwnerUUID().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
        }
        return false;
    }
}

