/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.task;

import com.google.common.collect.ImmutableMap;
import dev.sterner.the_catamount.entity.CatamountEntity;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class CatamountPounceTask<T extends CatamountEntity>
extends class_4097<T> {
    private final int interval;
    private final double animationTimeOfAttack;
    private long animationTime = 0L;
    private final int animationDuration;
    private final RunTask<T> runTask;
    private final FinishRunningTask<T> finishRunningTask;
    private boolean hasLeaped = false;

    public CatamountPounceTask(RunTask<T> runTask, FinishRunningTask<T> finishRunningTask, int interval, int animationDuration, double animationTimeOfAttack) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_22475, (Object)class_4141.field_18457));
        this.interval = interval;
        this.animationDuration = animationDuration;
        this.animationTimeOfAttack = animationTimeOfAttack;
        this.runTask = runTask;
        this.finishRunningTask = finishRunningTask;
    }

    protected boolean checkExtraStartConditions(class_3218 level, T entity) {
        class_1309 target = BrainUtils.getAttackTarget(entity);
        if (target == null) {
            return false;
        }
        double distance = entity.method_5858((class_1297)target);
        boolean isInRange = distance >= 9.0 && distance <= 36.0;
        boolean targetIsSmall = (double)target.method_17682() < 2.0;
        boolean notCrouched = !((CatamountEntity)((Object)entity)).isCrouched();
        boolean canSee = class_4215.method_24565(entity, (class_1309)target);
        return notCrouched && targetIsSmall && isInRange && canSee;
    }

    protected void start(class_3218 level, T entity, long gameTime) {
        entity.method_19540(true);
        class_1309 target = BrainUtils.getAttackTarget(entity);
        if (target != null) {
            entity.method_5980(target);
            class_4215.method_19554(entity, (class_1309)target);
            this.runTask.run(level, entity, gameTime);
            ((CatamountEntity)((Object)entity)).setCrouched(true);
            this.animationTime = gameTime + (long)this.animationDuration;
            this.hasLeaped = false;
        }
    }

    protected boolean canStillUse(class_3218 level, T entity, long gameTime) {
        return gameTime < this.animationTime && ((CatamountEntity)((Object)entity)).method_18868().method_18896(class_4140.field_22355);
    }

    protected void tick(class_3218 level, T entity, long gameTime) {
        class_1309 target = BrainUtils.getAttackTarget(entity);
        if (target == null) {
            return;
        }
        if (!this.hasLeaped && gameTime >= this.animationTime - (long)this.animationDuration + 2L) {
            this.performLeap(entity, target);
            this.hasLeaped = true;
        }
        if ((double)this.animationTime == (double)gameTime + this.animationTimeOfAttack) {
            entity.method_6104(class_1268.field_5808);
            if (entity.method_5858((class_1297)target) < 9.0) {
                ((CatamountEntity)((Object)entity)).method_6121((class_1297)target);
                if (target.method_5805()) {
                    target.method_5844(level.method_8320(entity.method_24515().method_10084()), new class_243(0.25, 0.05, 0.25));
                }
            }
        }
        class_4215.method_19554(entity, (class_1309)target);
    }

    protected void stop(class_3218 level, T entity, long gameTime) {
        entity.method_19540(false);
        this.finishRunningTask.run(level, entity, gameTime);
        this.animationTime = 0L;
        this.hasLeaped = false;
        ((CatamountEntity)((Object)entity)).method_18868().method_24525(class_4140.field_22475, (Object)true, (long)this.interval);
    }

    private void performLeap(T entity, class_1309 target) {
        class_243 direction = target.method_19538().method_1020(entity.method_19538()).method_1029();
        double horizontalSpeed = 0.8;
        double verticalSpeed = 0.4;
        class_243 leapVector = new class_243(direction.field_1352 * horizontalSpeed, verticalSpeed, direction.field_1350 * horizontalSpeed);
        entity.method_18799(entity.method_18798().method_1019(leapVector));
        ((CatamountEntity)((Object)entity)).field_6007 = true;
    }

    public static interface RunTask<T> {
        public void run(class_3218 var1, T var2, long var3);
    }

    public static interface FinishRunningTask<T> {
        public void run(class_3218 var1, T var2, long var3);
    }
}

