/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity.task;

import com.google.common.collect.ImmutableMap;
import dev.sterner.the_catamount.entity.brain.BrainUtils;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class GeckoMeleeAttackTask<T extends class_1308>
extends class_4097<T> {
    private final int interval;
    private final double animationTimeOfAttack;
    private long animationTime = 0L;
    private final int animationDuration;
    private final RunTask<T> runTask;
    private final FinishRunningTask<T> finishRunningTask;

    public GeckoMeleeAttackTask(RunTask<T> runTask, FinishRunningTask<T> finishRunningTask, int interval, double animationTime, double animationTimeOfAttack) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_22475, (Object)class_4141.field_18457));
        this.interval = interval;
        this.animationDuration = (int)animationTime;
        this.animationTimeOfAttack = animationTimeOfAttack;
        this.runTask = runTask;
        this.finishRunningTask = finishRunningTask;
    }

    protected boolean checkExtraStartConditions(class_3218 level, T entity) {
        class_1309 livingEntity = BrainUtils.getAttackTarget(entity);
        return class_4215.method_24565(entity, (class_1309)livingEntity) && entity.method_42150(livingEntity);
    }

    protected void start(class_3218 level, T mobEntity, long gameTime) {
        mobEntity.method_19540(true);
        class_1309 livingEntity = BrainUtils.getAttackTarget(mobEntity);
        mobEntity.method_5980(livingEntity);
        class_4215.method_19554(mobEntity, (class_1309)livingEntity);
        this.runTask.run(level, mobEntity, gameTime);
        this.animationTime = gameTime + (long)this.animationDuration;
    }

    protected boolean canStillUse(class_3218 level, T entity, long gameTime) {
        return gameTime < this.animationTime;
    }

    protected void tick(class_3218 level, T entity, long gameTime) {
        if (entity.method_18868().method_18896(class_4140.field_22355) && (double)this.animationTime == (double)gameTime + this.animationTimeOfAttack) {
            class_1309 livingEntity = BrainUtils.getAttackTarget(entity);
            entity.method_6104(class_1268.field_5808);
            entity.method_6121((class_1297)livingEntity);
        }
    }

    protected void stop(class_3218 level, T entity, long gameTime) {
        entity.method_19540(false);
        this.finishRunningTask.run(level, entity, gameTime);
        this.animationTime = 0L;
        entity.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)this.interval);
    }

    public static interface RunTask<T> {
        public void run(class_3218 var1, T var2, long var3);
    }

    public static interface FinishRunningTask<T> {
        public void run(class_3218 var1, T var2, long var3);
    }
}

