/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.events;

import fr.lynzel.fdn.attachment.HealthTracker;
import fr.lynzel.fdn.network.HealthUpdatePayload;
import fr.lynzel.fdn.registry.AttachmentTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ForgeEventHandler {
    public ForgeEventHandler(IEventBus forgeEventBus) {
        forgeEventBus.addListener(EventPriority.LOWEST, this::onEntityTick);
    }

    public void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        if (entity.level().isClientSide()) {
            return;
        }
        HealthTracker healthTracker = (HealthTracker)livingEntity.getData(AttachmentTypes.getHealthTracker());
        float currentHealth = livingEntity.getHealth();
        float previousHealth = healthTracker.getPreviousHealth();
        if (previousHealth != Float.MAX_VALUE && currentHealth != previousHealth) {
            DamageSource lastDamageSource;
            float amount = currentHealth - previousHealth;
            ResourceLocation lastDamageSourceType = null;
            if (amount < 0.0f && (lastDamageSource = livingEntity.getLastDamageSource()) != null) {
                lastDamageSourceType = livingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getKey((Object)lastDamageSource.type());
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)livingEntity, (CustomPacketPayload)new HealthUpdatePayload(livingEntity.getId(), amount, lastDamageSourceType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        healthTracker.setPreviousHealth(currentHealth);
    }
}

