/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record HealthUpdatePayload(int entityId, float amount, ResourceLocation damageType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HealthUpdatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"floatingdamagenumbers", (String)"health_update"));
    public static final StreamCodec<FriendlyByteBuf, HealthUpdatePayload> STREAM_CODEC = StreamCodec.of(HealthUpdatePayload::write, HealthUpdatePayload::read);

    public static HealthUpdatePayload read(FriendlyByteBuf friendlyByteBuf) {
        int entityId = friendlyByteBuf.readVarInt();
        float amount = friendlyByteBuf.readFloat();
        ResourceLocation damageType = friendlyByteBuf.readBoolean() ? friendlyByteBuf.readResourceLocation() : null;
        return new HealthUpdatePayload(entityId, amount, damageType);
    }

    public static void write(FriendlyByteBuf friendlyByteBuf, HealthUpdatePayload payload) {
        friendlyByteBuf.writeVarInt(payload.entityId);
        friendlyByteBuf.writeFloat(payload.amount);
        if (payload.damageType != null) {
            friendlyByteBuf.writeBoolean(true);
            friendlyByteBuf.writeResourceLocation(payload.damageType);
        } else {
            friendlyByteBuf.writeBoolean(false);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

