/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.util;

import net.minecraft.ChatFormatting;

public class ColorUtils {
    public static int fromRGB(int red, int green, int blue) {
        return ColorUtils.clampChannel(red) << 16 | ColorUtils.clampChannel(green) << 8 | ColorUtils.clampChannel(blue);
    }

    public static int fromARGB(int alpha, int red, int green, int blue) {
        return ColorUtils.clampChannel(alpha) << 24 | ColorUtils.clampChannel(red) << 16 | ColorUtils.clampChannel(green) << 8 | ColorUtils.clampChannel(blue);
    }

    public static int fromHex(String hex) {
        if (((String)hex).startsWith("#")) {
            hex = ((String)hex).substring(1);
        }
        if (((String)hex).length() == 3) {
            hex = "" + ((String)hex).charAt(0) + ((String)hex).charAt(0) + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2);
        }
        return Integer.parseInt((String)hex, 16);
    }

    public static int fromMinecraft(String color) {
        return ChatFormatting.valueOf((String)color.toUpperCase()).getColor();
    }

    public static int darkenColor(int rgb, float factor) {
        factor = ColorUtils.clampFactor(factor);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = Math.round((float)r * (1.0f - factor));
        g = Math.round((float)g * (1.0f - factor));
        b = Math.round((float)b * (1.0f - factor));
        return ColorUtils.fromRGB(r, g, b);
    }

    public static int brightenColor(int rgb, float factor) {
        factor = ColorUtils.clampFactor(factor);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = Math.round((float)r + (float)(255 - r) * (1.0f - factor));
        g = Math.round((float)g + (float)(255 - g) * (1.0f - factor));
        b = Math.round((float)b + (float)(255 - b) * (1.0f - factor));
        return ColorUtils.fromRGB(r, g, b);
    }

    public static int darkenColorWithAlpha(int argb, float factor) {
        factor = ColorUtils.clampFactor(factor);
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        r = Math.round((float)r * (1.0f - factor));
        g = Math.round((float)g * (1.0f - factor));
        b = Math.round((float)b * (1.0f - factor));
        return ColorUtils.fromARGB(a, r, g, b);
    }

    public static int brightenColorWithAlpha(int argb, float factor) {
        factor = ColorUtils.clampFactor(factor);
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        r = Math.round((float)r + (float)(255 - r) * (1.0f - factor));
        g = Math.round((float)g + (float)(255 - g) * (1.0f - factor));
        b = Math.round((float)b + (float)(255 - b) * (1.0f - factor));
        return ColorUtils.fromARGB(a, r, g, b);
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    private static int clampChannel(int value) {
        return Math.max(0, Math.min(255, value));
    }

    private static float clampFactor(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }

    public static boolean isValidMinecraftColor(String color) {
        try {
            ChatFormatting chatFormatting = ChatFormatting.valueOf((String)color);
            return chatFormatting.getColor() != null;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static boolean isValidHexColor(String color) {
        return color.matches("^#([0-9A-Fa-f]{3}|[0-9A-Fa-f]{6})$");
    }
}

