/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class DamageTypeUtils {
    public static Set<String> loadFromDisk() {
        HashSet<String> damageTypeSet = new HashSet<String>();
        File gameDirectory = Minecraft.getInstance().gameDirectory;
        File modDirectory = new File(gameDirectory, "floatingdamagenumbers");
        if (!modDirectory.exists()) {
            return damageTypeSet;
        }
        File damageTypesFile = new File(modDirectory, "damage_types.json");
        if (!damageTypesFile.exists()) {
            return damageTypeSet;
        }
        try (FileReader reader = new FileReader(damageTypesFile);){
            JsonArray jsonArray = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
            jsonArray.forEach(damageType -> damageTypeSet.add(damageType.getAsString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return damageTypeSet;
    }

    public static void saveToDisk(Set<ResourceLocation> damageTypes) {
        Set<String> damageTypeSet = DamageTypeUtils.loadFromDisk();
        damageTypes.forEach(damageType -> damageTypeSet.add(damageType.toString()));
        JsonArray jsonArray = new JsonArray();
        damageTypeSet.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        File gameDirectory = Minecraft.getInstance().gameDirectory;
        File modDirectory = new File(gameDirectory, "floatingdamagenumbers");
        if (!modDirectory.exists()) {
            modDirectory.mkdirs();
        }
        File damageTypesFile = new File(modDirectory, "damage_types.json");
        try (FileWriter writer = new FileWriter(damageTypesFile);){
            new Gson().toJson((JsonElement)jsonArray, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

