/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.theobsessed.TheObsessedMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheObsessedModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"the_obsessed");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheObsessedMod.addNetworkMessage(SavedDataSyncMessage.ID, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        TheObsessedMod.addNetworkMessage(PlayerVariablesSyncMessage.ID, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    public static class SavedDataSyncMessage
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("the_obsessed", "saved_data_sync");
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.type);
            if (this.data != null) {
                buffer.writeNbt((Tag)this.data.save(new CompoundTag()));
            }
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(SavedDataSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> {
                    if (message.type == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag()));
                    }
                }).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = new ResourceLocation("the_obsessed", "player_variables_sync");

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.readNbt());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)this.data.serializeNBT());
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(PlayerVariablesSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> ((PlayerVariables)Minecraft.getInstance().player.getData(PLAYER_VARIABLES)).deserializeNBT(message.data.serializeNBT())).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean idktarget = false;
        public double idkmood = 0.0;
        public double idkhealth_perplayer = 0.0;
        public boolean gift1 = false;
        public boolean gift2 = false;
        public boolean gift3 = false;
        public boolean obsessedpopup = false;
        public boolean debug_command = false;
        public boolean one_time_splash = false;
        public double obsession_length = 0.0;
        public boolean gift4 = false;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("idktarget", this.idktarget);
            nbt.putDouble("idkmood", this.idkmood);
            nbt.putDouble("idkhealth_perplayer", this.idkhealth_perplayer);
            nbt.putBoolean("gift1", this.gift1);
            nbt.putBoolean("gift2", this.gift2);
            nbt.putBoolean("gift3", this.gift3);
            nbt.putBoolean("obsessedpopup", this.obsessedpopup);
            nbt.putBoolean("debug_command", this.debug_command);
            nbt.putBoolean("one_time_splash", this.one_time_splash);
            nbt.putDouble("obsession_length", this.obsession_length);
            nbt.putBoolean("gift4", this.gift4);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.idktarget = nbt.getBoolean("idktarget");
            this.idkmood = nbt.getDouble("idkmood");
            this.idkhealth_perplayer = nbt.getDouble("idkhealth_perplayer");
            this.gift1 = nbt.getBoolean("gift1");
            this.gift2 = nbt.getBoolean("gift2");
            this.gift3 = nbt.getBoolean("gift3");
            this.obsessedpopup = nbt.getBoolean("obsessedpopup");
            this.debug_command = nbt.getBoolean("debug_command");
            this.one_time_splash = nbt.getBoolean("one_time_splash");
            this.obsession_length = nbt.getDouble("obsession_length");
            this.gift4 = nbt.getBoolean("gift4");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PlayerVariablesSyncMessage(this)});
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_mapvars";
        public String log_last_type_attempt = "\"\"";
        public String log_last_type__attempt_origin = "\"\"";
        public double obsessed_exists = 0.0;
        public boolean global_normaltick = false;
        public double obs_x = 0.0;
        public double obs_y = 0.0;
        public double obs_z = 0.0;
        public double obs_yaw = 0.0;
        public String last_despawn_reason = "\"\"";
        public String single_player_target_uuid = "\"\"";
        public double time_without_finding_single_target = 0.0;
        public double targeter_exists = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.log_last_type_attempt = nbt.getString("log_last_type_attempt");
            this.log_last_type__attempt_origin = nbt.getString("log_last_type__attempt_origin");
            this.obsessed_exists = nbt.getDouble("obsessed_exists");
            this.global_normaltick = nbt.getBoolean("global_normaltick");
            this.obs_x = nbt.getDouble("obs_x");
            this.obs_y = nbt.getDouble("obs_y");
            this.obs_z = nbt.getDouble("obs_z");
            this.obs_yaw = nbt.getDouble("obs_yaw");
            this.last_despawn_reason = nbt.getString("last_despawn_reason");
            this.single_player_target_uuid = nbt.getString("single_player_target_uuid");
            this.time_without_finding_single_target = nbt.getDouble("time_without_finding_single_target");
            this.targeter_exists = nbt.getDouble("targeter_exists");
        }

        public CompoundTag save(CompoundTag nbt) {
            nbt.putString("log_last_type_attempt", this.log_last_type_attempt);
            nbt.putString("log_last_type__attempt_origin", this.log_last_type__attempt_origin);
            nbt.putDouble("obsessed_exists", this.obsessed_exists);
            nbt.putBoolean("global_normaltick", this.global_normaltick);
            nbt.putDouble("obs_x", this.obs_x);
            nbt.putDouble("obs_y", this.obs_y);
            nbt.putDouble("obs_z", this.obs_z);
            nbt.putDouble("obs_yaw", this.obs_yaw);
            nbt.putString("last_despawn_reason", this.last_despawn_reason);
            nbt.putString("single_player_target_uuid", this.single_player_target_uuid);
            nbt.putDouble("time_without_finding_single_target", this.time_without_finding_single_target);
            nbt.putDouble("targeter_exists", this.targeter_exists);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, this)});
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag save(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.setDirty();
            if (world instanceof Level && !(level = (Level)world).isClientSide()) {
                PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, this)});
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.idktarget = original.idktarget;
            clone.idkmood = original.idkmood;
            clone.idkhealth_perplayer = original.idkhealth_perplayer;
            clone.gift1 = original.gift1;
            clone.gift2 = original.gift2;
            clone.gift3 = original.gift3;
            clone.one_time_splash = original.one_time_splash;
            clone.obsession_length = original.obsession_length;
            clone.gift4 = original.gift4;
            if (!event.isWasDeath()) {
                clone.obsessedpopup = original.obsessedpopup;
                clone.debug_command = original.debug_command;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, mapdata)});
                }
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }
    }
}

