/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.theobsessed.TheObsessedMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheObsessedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheObsessedMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheObsessedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.idktarget = message.data.idktarget;
                    variables.idkmood = message.data.idkmood;
                    variables.idkhealth_perplayer = message.data.idkhealth_perplayer;
                    variables.gift1 = message.data.gift1;
                    variables.gift2 = message.data.gift2;
                    variables.gift3 = message.data.gift3;
                    variables.obsessedpopup = message.data.obsessedpopup;
                    variables.debug_command = message.data.debug_command;
                    variables.one_time_splash = message.data.one_time_splash;
                    variables.obsession_length = message.data.obsession_length;
                    variables.gift4 = message.data.gift4;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean idktarget = false;
        public double idkmood = 0.0;
        public double idkhealth_perplayer = 0.0;
        public boolean gift1 = false;
        public boolean gift2 = false;
        public boolean gift3 = false;
        public boolean obsessedpopup = false;
        public boolean debug_command = false;
        public boolean one_time_splash = false;
        public double obsession_length = 0.0;
        public boolean gift4 = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("idktarget", this.idktarget);
            nbt.m_128347_("idkmood", this.idkmood);
            nbt.m_128347_("idkhealth_perplayer", this.idkhealth_perplayer);
            nbt.m_128379_("gift1", this.gift1);
            nbt.m_128379_("gift2", this.gift2);
            nbt.m_128379_("gift3", this.gift3);
            nbt.m_128379_("obsessedpopup", this.obsessedpopup);
            nbt.m_128379_("debug_command", this.debug_command);
            nbt.m_128379_("one_time_splash", this.one_time_splash);
            nbt.m_128347_("obsession_length", this.obsession_length);
            nbt.m_128379_("gift4", this.gift4);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.idktarget = nbt.m_128471_("idktarget");
            this.idkmood = nbt.m_128459_("idkmood");
            this.idkhealth_perplayer = nbt.m_128459_("idkhealth_perplayer");
            this.gift1 = nbt.m_128471_("gift1");
            this.gift2 = nbt.m_128471_("gift2");
            this.gift3 = nbt.m_128471_("gift3");
            this.obsessedpopup = nbt.m_128471_("obsessedpopup");
            this.debug_command = nbt.m_128471_("debug_command");
            this.one_time_splash = nbt.m_128471_("one_time_splash");
            this.obsession_length = nbt.m_128459_("obsession_length");
            this.gift4 = nbt.m_128471_("gift4");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_obsessed", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_mapvars";
        public String log_last_type_attempt = "\"\"";
        public String log_last_type__attempt_origin = "\"\"";
        public double obsessed_exists = 0.0;
        public boolean global_normaltick = false;
        public double obs_x = 0.0;
        public double obs_y = 0.0;
        public double obs_z = 0.0;
        public double obs_yaw = 0.0;
        public String last_despawn_reason = "\"\"";
        public String single_player_target_uuid = "\"\"";
        public double time_without_finding_single_target = 0.0;
        public double targeter_exists = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.log_last_type_attempt = nbt.m_128461_("log_last_type_attempt");
            this.log_last_type__attempt_origin = nbt.m_128461_("log_last_type__attempt_origin");
            this.obsessed_exists = nbt.m_128459_("obsessed_exists");
            this.global_normaltick = nbt.m_128471_("global_normaltick");
            this.obs_x = nbt.m_128459_("obs_x");
            this.obs_y = nbt.m_128459_("obs_y");
            this.obs_z = nbt.m_128459_("obs_z");
            this.obs_yaw = nbt.m_128459_("obs_yaw");
            this.last_despawn_reason = nbt.m_128461_("last_despawn_reason");
            this.single_player_target_uuid = nbt.m_128461_("single_player_target_uuid");
            this.time_without_finding_single_target = nbt.m_128459_("time_without_finding_single_target");
            this.targeter_exists = nbt.m_128459_("targeter_exists");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("log_last_type_attempt", this.log_last_type_attempt);
            nbt.m_128359_("log_last_type__attempt_origin", this.log_last_type__attempt_origin);
            nbt.m_128347_("obsessed_exists", this.obsessed_exists);
            nbt.m_128379_("global_normaltick", this.global_normaltick);
            nbt.m_128347_("obs_x", this.obs_x);
            nbt.m_128347_("obs_y", this.obs_y);
            nbt.m_128347_("obs_z", this.obs_z);
            nbt.m_128347_("obs_yaw", this.obs_yaw);
            nbt.m_128359_("last_despawn_reason", this.last_despawn_reason);
            nbt.m_128359_("single_player_target_uuid", this.single_player_target_uuid);
            nbt.m_128347_("time_without_finding_single_target", this.time_without_finding_single_target);
            nbt.m_128347_("targeter_exists", this.targeter_exists);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.idktarget = original.idktarget;
            clone.idkmood = original.idkmood;
            clone.idkhealth_perplayer = original.idkhealth_perplayer;
            clone.gift1 = original.gift1;
            clone.gift2 = original.gift2;
            clone.gift3 = original.gift3;
            clone.one_time_splash = original.one_time_splash;
            clone.obsession_length = original.obsession_length;
            clone.gift4 = original.gift4;
            if (!event.isWasDeath()) {
                clone.obsessedpopup = original.obsessedpopup;
                clone.debug_command = original.debug_command;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TheObsessedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

