/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.network;

import fr.lynzel.fdn.config.ClientConfig;
import fr.lynzel.fdn.network.HealthUpdatePayload;
import fr.lynzel.fdn.particle.DamageParticleType;
import fr.lynzel.fdn.util.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleHealthUpdate(HealthUpdatePayload payload, IPayloadContext context) {
        Entity entity;
        if (!((Boolean)ClientConfig.MOD_IS_ENABLED.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && (entity = level.getEntity(payload.entityId())) != null) {
            if (entity.is((Entity)minecraft.player)) {
                return;
            }
            double x = entity.getX();
            double y = entity.getBoundingBox().maxY + 0.25 + (entity.isOnFire() ? 1.0 : 0.0);
            double z = entity.getZ();
            float absRoundedAmount = Math.abs((float)Math.round(payload.amount() * 2.0f) / 2.0f);
            String text = absRoundedAmount == (float)((int)Math.abs(absRoundedAmount)) ? String.valueOf((int)Math.abs(absRoundedAmount)) : String.format("%.1f", Float.valueOf(Math.abs(absRoundedAmount)));
            String colorString = payload.amount() < 0.0f ? (String)ClientConfig.DAMAGE_COLORS.getOrDefault(payload.damageType().toString(), ClientConfig.DAMAGE_COLORS.get("default")).get() : (String)ClientConfig.HEAL_COLORS.get("default").get();
            if (colorString.equalsIgnoreCase("NONE")) {
                return;
            }
            int color = ColorUtils.isValidHexColor(colorString) ? ColorUtils.fromHex(colorString) : ColorUtils.fromMinecraft(colorString);
            DamageParticleType damageParticleType = new DamageParticleType(text, color);
            level.addParticle((ParticleOptions)damageParticleType, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

