/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.util;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class GUIUtils {
    public static Vec2 worldPositionToScreenPosition(Vec3 worldPosition) {
        Minecraft MC = Minecraft.getInstance();
        Camera camera = MC.gameRenderer.getMainCamera();
        Vec3 cameraPosition = camera.getPosition();
        Vec3 relativePosition = worldPosition.subtract(cameraPosition);
        Quaternionf rotation = new Quaternionf((Quaternionfc)camera.rotation()).conjugate();
        Matrix4f view = new Matrix4f().rotation((Quaternionfc)rotation).translate((float)relativePosition.x, (float)relativePosition.y, (float)relativePosition.z);
        Matrix4f projection = new Matrix4f((Matrix4fc)MC.gameRenderer.getProjectionMatrix((float)((Integer)MC.options.fov().get()).intValue()));
        Vector4f clippingSpacePosition = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        clippingSpacePosition.mul((Matrix4fc)view);
        clippingSpacePosition.mul((Matrix4fc)projection);
        if (clippingSpacePosition.w <= 0.0f) {
            return null;
        }
        float normalizedX = clippingSpacePosition.x / clippingSpacePosition.w;
        float normalizedY = clippingSpacePosition.y / clippingSpacePosition.w;
        int screenWidth = MC.getWindow().getGuiScaledWidth();
        int screenHeight = MC.getWindow().getGuiScaledHeight();
        double screenX = ((double)normalizedX * 0.5 + 0.5) * (double)screenWidth;
        double screenY = ((double)normalizedY * -0.5 + 0.5) * (double)screenHeight;
        return new Vec2((float)screenX, (float)screenY);
    }
}

