/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture;

import com.google.common.collect.Sets;
import dev.apexstudios.fantasyfurniture.FurnitureBlockEntities;
import dev.apexstudios.fantasyfurniture.FurnitureMenus;
import dev.apexstudios.fantasyfurniture.ctm.CtmPacks;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationSetup;
import dev.apexstudios.registree.api.Registree;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod(value="fantasyfurniture")
public final class FantasyFurniture {
    public static final String ID = "fantasyfurniture";
    public static final Registree REGISTREE = Registree.create((String)"fantasyfurniture");
    public static final TagKey<Item> FURNITURE_PLANKS = REGISTREE.tag(Registries.ITEM, "furniture_planks");
    public static final TagKey<Item> FURNITURE_WOOL = REGISTREE.tag(Registries.ITEM, "furniture_wool");
    public static final TagKey<Item> FURNITURE_BRICKS = REGISTREE.tag(Registries.ITEM, "furniture_bricks");
    public static final Set<String> FURNITURE_MODS = Sets.newHashSet();
    public static final String LOADING_ISSUE_KEY = "fantasyfurniture.loading_issue.missing_furniture_sets";

    public FantasyFurniture(IEventBus modBus) {
        REGISTREE.registerEvents(modBus);
        FurnitureStationSetup.register(modBus);
        FurnitureBlockEntities.register(modBus);
        FurnitureMenus.register(modBus);
        CtmPacks.register(modBus);
        modBus.addListener(FMLCommonSetupEvent.class, event -> {
            if (FURNITURE_MODS.isEmpty()) {
                ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)LOADING_ISSUE_KEY, (Object[])new Object[0]));
            }
        });
    }

    public static ResourceLocation identifier(String identifier) {
        return REGISTREE.registryName(identifier);
    }

    public static String id(String identifier) {
        return "fantasyfurniture:" + identifier;
    }

    private record CtmPack(String packId, String packName) {
    }
}

