/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.multiblock.BedMultiBlock;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlockProperty;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BedDoubleBlock
extends BedMultiBlock {
    public static final MultiBlockProperty MULTI_BLOCK = MultiBlockProperty.create(builder -> builder.with(-1, 0, 0).with(-1, 0, -1).with(0, 0, -1));
    private final Map<Direction, VoxelShape> shapes;

    public BedDoubleBlock(BlockBehaviour.Properties properties, VoxelShape baseShape) {
        super(properties);
        this.shapes = Shapes.rotateHorizontal((VoxelShape)baseShape);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        VoxelShape shape = this.shapes.get(facing);
        return FurnitureUtil.getShape(shape, blockState, pos);
    }

    public MultiBlockProperty getMultiBlockProperty() {
        return MULTI_BLOCK;
    }
}

