/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FurnitureDoorBlock
extends DoorBlock {
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)FurnitureDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)32.0, (double)16.0));

    public FurnitureDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSet) {
        super(blockSet, properties);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getCounterClockWise();
        Direction dir = ((Boolean)blockState.getValue((Property)OPEN)).booleanValue() ? (blockState.getValue((Property)HINGE) == DoorHingeSide.RIGHT ? facing.getCounterClockWise() : facing.getClockWise()) : facing;
        VoxelShape shape = SHAPES.get(dir);
        if (blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return shape.move(0.0, -1.0, 0.0);
        }
        return shape;
    }
}

