/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.block.Seat;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import dev.apexstudios.fantasyfurniture.block.SeatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class SeatMultiBlock
extends SeatBlock
implements Seat,
MultiBlock {
    public SeatMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getMultiBlockProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getMultiBlockProperty()});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null || !MultiBlock.canPlace((BlockPlaceContext)context, (BlockState)placementBlockState)) {
            return null;
        }
        return placementBlockState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, blockState, placer, stack);
        MultiBlock.setBlockStates((Level)level, (BlockPos)pos, (BlockState)blockState);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState blockState) {
        super.destroy(level, pos, blockState);
        MultiBlock.destroyBlocks((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.spawnDestroyParticles(level, player, pos, blockState);
        MultiBlock.spawnDestroyParticles((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState, (Entity)player);
    }

    public Vec3 getSeatPosition(BlockGetter level, BlockPos pos, BlockState blockState) {
        if (blockState.is(ApexTags.Blocks.SEAT_PER_BLOCK)) {
            return super.getSeatPosition(level, pos, blockState);
        }
        BlockPos origin = MultiBlock.getOrigin((BlockPos)pos, (BlockState)blockState);
        BlockState originBlockState = level.getBlockState(origin);
        return super.getSeatPosition(level, origin, originBlockState);
    }

    public void setSeatOccupied(Level level, BlockPos pos, BlockState blockState, boolean occupied) {
        if (blockState.is(ApexTags.Blocks.SEAT_PER_BLOCK)) {
            super.setSeatOccupied(level, pos, blockState, occupied);
        } else {
            MultiBlock.forEachPos((BlockPos)pos, (BlockState)blockState, (otherPos, otherBlockState) -> super.setSeatOccupied(level, otherPos, otherBlockState, occupied));
        }
    }
}

