/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.block.SimpleHorizontalDirectionalBlock;
import dev.apexstudios.apexcore.lib.util.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.property.ShelfConnection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfBlock
extends SimpleHorizontalDirectionalBlock {
    private final Map<Direction, VoxelShape> leftShapes;
    private final Map<Direction, VoxelShape> rightShapes;
    private final Map<Direction, VoxelShape> topShapes;

    public ShelfBlock(BlockBehaviour.Properties properties, VoxelShape leftShape, VoxelShape rightShape, VoxelShape topShape) {
        super(properties);
        this.leftShapes = Shapes.rotateHorizontal((VoxelShape)leftShape);
        this.rightShapes = Shapes.rotateHorizontal((VoxelShape)rightShape);
        this.topShapes = Shapes.rotateHorizontal((VoxelShape)topShape);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ShelfConnection.PROPERTY, (Comparable)((Object)ShelfConnection.BOTH)));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        VoxelShape leftShape = this.leftShapes.get(facing);
        VoxelShape rightShape = this.rightShapes.get(facing);
        VoxelShape topShape = this.topShapes.get(facing);
        return switch ((ShelfConnection)((Object)blockState.getValue(ShelfConnection.PROPERTY))) {
            default -> throw new MatchException(null, null);
            case ShelfConnection.LEFT -> ApexShapes.join((VoxelShape)leftShape, (VoxelShape[])new VoxelShape[]{topShape});
            case ShelfConnection.RIGHT -> ApexShapes.join((VoxelShape)rightShape, (VoxelShape[])new VoxelShape[]{topShape});
            case ShelfConnection.NONE -> ApexShapes.join((VoxelShape)leftShape, (VoxelShape[])new VoxelShape[]{rightShape, topShape});
            case ShelfConnection.BOTH -> topShape;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ShelfConnection.PROPERTY});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return ShelfConnection.setConnection((BlockGetter)level, pos, blockState);
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            result = ShelfConnection.setConnection((BlockGetter)level, pos, result);
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }
}

