/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block.property;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public enum ShelfConnection implements StringRepresentable
{
    LEFT("left"),
    RIGHT("right"),
    BOTH("center"),
    NONE("single");

    public static final EnumProperty<ShelfConnection> PROPERTY;
    private final String serializedName;

    private ShelfConnection(String serializedName) {
        this.serializedName = serializedName;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public String getModelSuffix() {
        return "_" + this.serializedName;
    }

    public static BlockState setConnection(BlockGetter level, BlockPos pos, BlockState blockState) {
        return (BlockState)blockState.setValue(PROPERTY, (Comparable)((Object)ShelfConnection.determine(level, pos, blockState)));
    }

    private static ShelfConnection determine(BlockGetter level, BlockPos pos, BlockState blockState) {
        boolean hasLeft = ShelfConnection.canConnect(level, pos, blockState, true);
        boolean hasRight = ShelfConnection.canConnect(level, pos, blockState, false);
        if (hasLeft && hasRight) {
            return BOTH;
        }
        if (hasLeft) {
            return LEFT;
        }
        if (hasRight) {
            return RIGHT;
        }
        return NONE;
    }

    private static boolean canConnect(BlockGetter level, BlockPos pos, BlockState blockState, boolean left) {
        Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction offset = left ? facing.getCounterClockWise() : facing.getClockWise();
        BlockPos otherPos = pos.relative(offset);
        BlockState otherBlockState = level.getBlockState(otherPos);
        if (!otherBlockState.is(blockState.getBlock())) {
            return false;
        }
        return otherBlockState.getValue((Property)HorizontalDirectionalBlock.FACING) == facing;
    }

    static {
        PROPERTY = EnumProperty.create((String)"connection", ShelfConnection.class);
    }
}

