/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.ctm.ExtendedBlockStateProvider;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import dev.apexstudios.registree.api.Registree;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

final class AthenaProvider
extends ExtendedBlockStateProvider {
    public static final String ID = "athena";
    public static final ProviderType<AthenaProvider> PROVIDER_TYPE = ProviderType.register((ResourceLocation)FantasyFurniture.identifier("ctm/athena"), AthenaProvider::new);

    AthenaProvider() {
    }

    public void with(Registree registree) {
        FurnitureUtil.Names.block(registree, "carpet", carpet -> {
            Holder.Reference wool = registree.getOrThrow(Registries.BLOCK, "wool");
            ResourceLocation registryName = wool.key().location();
            ResourceLocation ctm = registryName.withPrefix("block/ctm/");
            HashMap textures = Maps.newHashMap();
            textures.put("particle", registryName.withPrefix("block/"));
            textures.put("center", ctm.withSuffix("_center"));
            textures.put("empty", ctm.withSuffix("_empty"));
            textures.put("horizontal", ctm.withSuffix("_horizontal"));
            textures.put("vertical", ctm.withSuffix("_vertical"));
            this.with((Block)wool.value(), "ctm", textures);
            this.with((Block)carpet, "carpet", textures);
        });
    }

    private void with(Block block, String loader, Map<String, ResourceLocation> textures) {
        this.with(block, root -> {
            root.addProperty("athena:loader", "athena:" + loader);
            root.add("ctm_textures", (JsonElement)Util.make((Object)new JsonObject(), texturesJson -> textures.forEach((key, texture) -> texturesJson.addProperty(key, texture.toString()))));
        });
    }
}

