/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import dev.apexstudios.apexcore.core.client.DyeColorItemTintSource;
import dev.apexstudios.apexcore.lib.block.Dyeable;
import dev.apexstudios.apexcore.lib.data.provider.model.ModelProvider;
import dev.apexstudios.fantasyfurniture.ctm.SimpleJsonProvider;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import dev.apexstudios.registree.api.Registree;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public interface LegacyDoorsProvider {
    public static void register(ModelProvider provider, Registree registree) {
        boolean dyeable = SimpleJsonProvider.isDyeable(registree);
        BlockModelGenerators blockModels = provider.blockModels();
        Block[] blocks = FurnitureUtil.Names.blocks(registree, "door_single", "door_double");
        provider.knownBlocks(() -> Stream.of(blocks).map(Block::builtInRegistryHolder)).knownItems(() -> Stream.of(blocks).map(Block::asItem).map(Item::builtInRegistryHolder));
        for (Block block : blocks) {
            ResourceLocation model = ModelLocationUtils.getModelLocation((Item)block.asItem(), (String)"_3d");
            if (dyeable) {
                blockModels.registerSimpleTintedItemModel(block, model, (ItemTintSource)new DyeColorItemTintSource(Dyeable.DEFAULT_COLOR));
                continue;
            }
            blockModels.registerSimpleItemModel(block, model);
        }
    }
}

