/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.blaze3d.platform.NativeImage;
import dev.apexstudios.apexcore.core.data.provider.BaseProvider;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

final class TextureProvider
implements BaseProvider {
    public static final ProviderType<TextureProvider> PROVIDER_TYPE = ProviderType.register((ResourceLocation)FantasyFurniture.identifier("ctm/texture"), TextureProvider::new);
    private final List<Textures> textures = Lists.newArrayList();

    TextureProvider() {
    }

    public void with(Block block, boolean dyeable) {
        ResourceLocation blockName = block.builtInRegistryHolder().key().location();
        this.textures.add(Textures.create(blockName));
        if (dyeable) {
            this.textures.add(Textures.create(blockName.withSuffix("_tint")));
        }
    }

    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        ResourceManager resourceManager = context.getResourceManager(PackType.CLIENT_RESOURCES);
        Path assetsDir = context.output().getOutputFolder(PackOutput.Target.RESOURCE_PACK);
        return CompletableFuture.allOf((CompletableFuture[])this.textures.stream().map(texture -> this.generate(cache, resourceManager, (Textures)texture, assetsDir)).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<?> generate(CachedOutput cache, ResourceManager resourceManager, Textures textures, Path assetsDir) {
        return CompletableFuture.runAsync(() -> {
            try (InputStream baseIs = resourceManager.open(this.expand(textures.base));
                 InputStream centerIs = resourceManager.open(this.expand(textures.center));
                 InputStream emptyIs = resourceManager.open(this.expand(textures.empty));
                 InputStream horizontalIs = resourceManager.open(this.expand(textures.horizontal));
                 InputStream verticalIs = resourceManager.open(this.expand(textures.vertical));){
                LoadedTextures loaded = new LoadedTextures(textures, NativeImage.read((InputStream)baseIs), NativeImage.read((InputStream)centerIs), NativeImage.read((InputStream)emptyIs), NativeImage.read((InputStream)horizontalIs), NativeImage.read((InputStream)verticalIs));
                this.generate(cache, loaded, assetsDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ResourceLocation expand(ResourceLocation modelPath) {
        return modelPath.withPath(path -> "textures/block/" + path + ".png");
    }

    private void generate(CachedOutput cache, LoadedTextures textures, Path assetsDir) throws IOException {
        this.validateSameSize(textures.base, textures.center, textures.empty, textures.horizontal, textures.vertical);
        this.generate2x2(cache, textures, assetsDir);
        this.generateStrip(cache, textures, assetsDir);
    }

    private void validateSameSize(NativeImage ... images) {
        for (int i = 0; i < images.length; ++i) {
            for (int j = images.length - 1; j >= 0; --j) {
                if (i == j) continue;
                this.validateSameSize(images[i], images[j]);
            }
        }
    }

    private void validateSameSize(NativeImage a, NativeImage b) {
        if (a.getWidth() != b.getWidth()) {
            throw new IllegalStateException("Textures must have the same width");
        }
        if (a.getHeight() != b.getHeight()) {
            throw new IllegalStateException("Textures must have the same height");
        }
    }

    private void generate2x2(CachedOutput cache, LoadedTextures textures, Path assetsDir) throws IOException {
        int width = textures.base.getWidth();
        int height = textures.base.getHeight();
        ResourceLocation baseName = this.expand(textures.paths.base.withPath(path -> "ctm/" + path + "_simple"));
        Path outputPath = assetsDir.resolve(baseName.getNamespace()).resolve(baseName.getPath());
        try (NativeImage output = new NativeImage(NativeImage.Format.RGBA, width * 2, height * 2, false);){
            textures.empty.copyRect(output, 0, 0, 0, 0, width, height, false, false);
            textures.vertical.copyRect(output, 0, 0, width, 0, width, height, false, false);
            textures.horizontal.copyRect(output, 0, 0, 0, height, width, height, false, false);
            textures.center.copyRect(output, 0, 0, width, height, width, height, false, false);
            this.write(cache, output, outputPath);
        }
    }

    private void generateStrip(CachedOutput cache, LoadedTextures textures, Path assetsDir) throws IOException {
        int width = textures.base.getWidth();
        int height = textures.base.getHeight();
        NativeImage[] slices = new NativeImage[]{textures.base, textures.empty, textures.vertical, textures.horizontal, textures.center};
        ResourceLocation baseName = this.expand(textures.paths.base.withPath(path -> "ctm/" + path + "_simple_vertical"));
        Path outputPath = assetsDir.resolve(baseName.getNamespace()).resolve(baseName.getPath());
        try (NativeImage output = new NativeImage(NativeImage.Format.RGBA, width * slices.length, height, false);){
            for (int i = 0; i < slices.length; ++i) {
                NativeImage slice = slices[i];
                slice.copyRect(output, 0, 0, i * width, 0, width, height, false, false);
            }
            this.write(cache, output, outputPath);
        }
    }

    private void write(CachedOutput cache, NativeImage image, Path path) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage img = new BufferedImage(width, height, 1);
        img.setRGB(0, 0, width, height, image.getPixels(), 0, 0);
        this.writeDummy(cache, path);
        Files.deleteIfExists(path);
        image.writeToFile(path);
    }

    private void writeDummy(CachedOutput cache, Path path) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        HashingOutputStream ho = new HashingOutputStream(Hashing.sha1(), (OutputStream)bao);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)ho, StandardCharsets.UTF_8));){
            writer.write("dummy-value");
        }
        Files.deleteIfExists(path);
        cache.writeIfNeeded(path, bao.toByteArray(), ho.hash());
    }

    private record Textures(ResourceLocation base, ResourceLocation center, ResourceLocation empty, ResourceLocation horizontal, ResourceLocation vertical) {
        public static Textures create(ResourceLocation blockName) {
            ResourceLocation ctmName = blockName.withPrefix("ctm/");
            return new Textures(blockName, ctmName.withSuffix("_center"), ctmName.withSuffix("_empty"), ctmName.withSuffix("_horizontal"), ctmName.withSuffix("_vertical"));
        }
    }

    private record LoadedTextures(Textures paths, NativeImage base, NativeImage center, NativeImage empty, NativeImage horizontal, NativeImage vertical) {
    }
}

