/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.station;

import dev.apexstudios.apexcore.lib.menu.SimpleMenuScreen;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationMenu;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipe;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;

public final class FurnitureStationScreen
extends AbstractContainerScreen<FurnitureStationMenu> {
    public static final ResourceLocation SPRITE_ARROW = FantasyFurniture.identifier("container/furniture_station/arrow");
    public static final ResourceLocation SPRITE_RECIPE = FantasyFurniture.identifier("container/furniture_station/recipe");
    public static final ResourceLocation SPRITE_RECIPE_BACKGROUND = FantasyFurniture.identifier("container/furniture_station/recipe_background");
    public static final ResourceLocation SPRITE_RECIPE_HIGHLIGHTED = FantasyFurniture.identifier("container/furniture_station/recipe_highlighted");
    public static final ResourceLocation SPRITE_RECIPE_SELECTED = FantasyFurniture.identifier("container/furniture_station/recipe_selected");
    public static final ResourceLocation SPRITE_SCROLLER = FantasyFurniture.identifier("container/furniture_station/scroller");
    public static final ResourceLocation SPRITE_SCROLLER_BACKGROUND = FantasyFurniture.identifier("container/furniture_station/scroller_background");
    public static final ResourceLocation SPRITE_SCROLLER_DISABLED = FantasyFurniture.identifier("container/furniture_station/scroller_disabled");
    private float scrollOffs = 0.0f;
    private boolean scrolling = false;
    private int startIndex = 0;
    private boolean displayRecipes = false;
    private int recipeBackgroundX;
    private int recipeBackgroundY;
    private int recipeBackgroundWidth;
    private int recipeBackgroundHeight;
    private int recipeX;
    private int recipeY;
    private int recipeColumns;
    private int recipeRows;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private int scrollBarBackgroundWidth;
    private int scrollBarBackgroundHeight;
    private int scrollBarFullHeight;

    FurnitureStationScreen(FurnitureStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        menu.registerListener(this::containerChanged);
    }

    protected void init() {
        super.init();
        this.updatePositions();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.renderWindow(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITE_ARROW, this.recipeX + 54 + 15, this.recipeY - 18 - 7, 60, 16);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITE_RECIPE_BACKGROUND, this.recipeBackgroundX, this.recipeBackgroundY, this.recipeBackgroundWidth, this.recipeBackgroundHeight);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITE_SCROLLER_BACKGROUND, this.scrollBarX, this.scrollBarY, this.scrollBarBackgroundWidth, this.scrollBarBackgroundHeight);
        this.renderButtons(graphics, mouseX, mouseY, false);
        int k = (int)(57.0f * this.scrollOffs);
        ResourceLocation scrollerSprite = this.isScrollBarActive() ? SPRITE_SCROLLER : SPRITE_SCROLLER_DISABLED;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, scrollerSprite, this.scrollBarX + 1, this.scrollBarY + 1 + k, this.scrollBarWidth, this.scrollBarHeight);
        this.renderButtons(graphics, mouseX, mouseY, true);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (((FurnitureStationMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            return;
        }
        if (this.displayRecipes) {
            int maxSlots = this.recipeColumns * this.recipeRows;
            int lastIndex = this.startIndex + maxSlots;
            List<FurnitureStationRecipe> recipes = ((FurnitureStationMenu)this.menu).recipes();
            for (int index = this.startIndex; index < lastIndex && index < recipes.size(); ++index) {
                int slotIndex = index - this.startIndex;
                int slotX = this.recipeX + slotIndex % this.recipeColumns * 18;
                int slotY = this.recipeY + slotIndex / this.recipeColumns * 18;
                if (mouseX < slotX || mouseY < slotY || mouseX >= slotX + 18 || mouseY >= slotY + 18) continue;
                guiGraphics.setTooltipForNextFrame(this.font, this.displayStack(index), mouseX, mouseY);
                break;
            }
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean held) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int maxSlots = this.recipeColumns * this.recipeRows;
            int lastIndex = this.startIndex + maxSlots;
            List<FurnitureStationRecipe> recipes = ((FurnitureStationMenu)this.menu).recipes();
            for (int index = this.startIndex; index < lastIndex && index < recipes.size(); ++index) {
                if (((FurnitureStationMenu)this.menu).selectedRecipe() == index) continue;
                int slotIndex = index - this.startIndex;
                double slotX = this.recipeX + slotIndex % this.recipeColumns * 18;
                double slotY = this.recipeY + slotIndex / this.recipeColumns * 18;
                if (!(event.x() >= slotX && event.y() >= slotY && event.x() < slotX + 18.0 && event.y() < slotY + 18.0 && ((FurnitureStationMenu)this.menu).clickMenuButton((Player)this.minecraft.player, index))) continue;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((FurnitureStationMenu)this.menu).containerId, index);
                return true;
            }
            if (event.x() >= (double)this.scrollBarX && event.y() >= (double)this.scrollBarY && event.x() < (double)(this.scrollBarX + this.scrollBarWidth) && event.y() < (double)(this.scrollBarY + this.scrollBarFullHeight)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(event, held);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int scrollEndY = this.recipeY + this.scrollBarFullHeight;
            this.scrollOffs = (float)(event.y() - (double)this.recipeY - (double)((float)this.scrollBarHeight / 2.0f)) / (float)(scrollEndY - this.recipeY - this.scrollBarHeight);
            this.scrollOffs = Math.clamp((float)0.0f, (float)1.0f, (float)this.scrollOffs);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * this.recipeColumns;
            return true;
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float amount = (float)scrollY / (float)offscreenRows;
            this.scrollOffs = Math.clamp((float)0.0f, (float)1.0f, (float)(this.scrollOffs - amount));
            this.startIndex = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5) * this.recipeColumns;
        }
        return true;
    }

    private void updatePositions() {
        this.recipeColumns = 8;
        this.recipeRows = 4;
        this.recipeBackgroundWidth = 18 * this.recipeColumns + 1;
        this.recipeBackgroundHeight = 18 * this.recipeRows + 2;
        this.scrollBarBackgroundWidth = 14;
        this.scrollBarBackgroundHeight = this.recipeBackgroundHeight;
        this.scrollBarFullHeight = this.scrollBarBackgroundHeight - 2;
        this.scrollBarWidth = this.scrollBarBackgroundWidth - 2;
        this.scrollBarHeight = 15;
        this.recipeBackgroundX = this.leftPos - 3 + (this.imageWidth / 2 - this.recipeBackgroundWidth / 2 - this.scrollBarWidth / 2);
        this.recipeBackgroundY = this.topPos + 32;
        this.recipeX = this.recipeBackgroundX + 1;
        this.recipeY = this.recipeBackgroundY + 1;
        this.scrollBarX = this.recipeBackgroundX + this.recipeBackgroundWidth + 1;
        this.scrollBarY = this.recipeBackgroundY;
        this.imageHeight = 196;
    }

    private void renderWindow(GuiGraphics graphics) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SimpleMenuScreen.WINDOW_SPRITE, 0, 0, this.imageWidth, this.imageHeight + 1);
        for (Slot slot : ((FurnitureStationMenu)this.menu).slots) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SimpleMenuScreen.SLOT_SPRITE, slot.x - 1, slot.y - 1, 18, 18);
        }
        graphics.pose().popMatrix();
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, boolean drawItem) {
        int maxSlots = this.recipeColumns * this.recipeRows;
        int lastIndex = this.startIndex + maxSlots;
        List<FurnitureStationRecipe> recipes = ((FurnitureStationMenu)this.menu).recipes();
        for (int index = this.startIndex; index < lastIndex && index < recipes.size(); ++index) {
            int slotIndex = index - this.startIndex;
            int slotX = this.recipeX + slotIndex % this.recipeColumns * 18;
            int slotY = this.recipeY + slotIndex / this.recipeColumns * 18;
            if (drawItem) {
                graphics.renderItem(this.displayStack(index), slotX + 1, slotY + 1);
                continue;
            }
            ResourceLocation slotSprite = SPRITE_RECIPE;
            if (index == ((FurnitureStationMenu)this.menu).selectedRecipe()) {
                slotSprite = SPRITE_RECIPE_SELECTED;
            } else if (mouseX >= slotX && mouseY >= slotY && mouseX < slotX + 18 && mouseY < slotY + 18) {
                slotSprite = SPRITE_RECIPE_HIGHLIGHTED;
            }
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, slotSprite, slotX, slotY, 18, 18);
        }
    }

    private boolean isScrollBarActive() {
        int maxSlots = this.recipeColumns * this.recipeRows;
        return this.displayRecipes && ((FurnitureStationMenu)this.menu).recipes().size() > maxSlots;
    }

    private int getOffscreenRows() {
        return (((FurnitureStationMenu)this.menu).recipes().size() + this.recipeColumns - 1) / this.recipeColumns - this.recipeRows;
    }

    private void containerChanged() {
        this.displayRecipes = ((FurnitureStationMenu)this.menu).hasInput();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updatePositions();
    }

    private ItemStack displayStack(int index) {
        List<FurnitureStationRecipe> recipes = ((FurnitureStationMenu)this.menu).recipes();
        return FurnitureStationMenu.isValidRecipeIndex(recipes, index) ? recipes.get(index).result() : ItemStack.EMPTY;
    }
}

