/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.apexstudios.apexcore.lib.data.ProviderTypes;
import dev.apexstudios.apexcore.lib.data.pack.PackGenerator;
import dev.apexstudios.apexcore.lib.data.provider.RecipeProvider;
import dev.apexstudios.apexcore.lib.data.provider.loot.BlockLootSubProvider;
import dev.apexstudios.apexcore.lib.data.provider.loot.LootTableProvider;
import dev.apexstudios.apexcore.lib.data.provider.tag.IntrusiveTagBuilder;
import dev.apexstudios.apexcore.lib.data.provider.tag.IntrusiveTagProvider;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import dev.apexstudios.apexcore.lib.util.TagPair;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipeBuilder;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationSetup;
import dev.apexstudios.placementvisualizer.api.BlockItemPlacementEvent;
import dev.apexstudios.registree.api.Registree;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;

public interface FurnitureDataUtil {
    public static void registerDataGen(DataGenContext context, PackGenerator<?> pack) {
        pack.providing(ProviderTypes.LOOT_TABLE, ($, provider) -> FurnitureDataUtil.registerLootTables(context, provider)).providing(ProviderTypes.BLOCK_TAGS, ($, provider) -> FurnitureDataUtil.registerBlockTags(context, (IntrusiveTagProvider<Block>)provider)).providing(ProviderTypes.ITEM_TAGS, ($, provider) -> FurnitureDataUtil.registerItemTags(context, (IntrusiveTagProvider<Item>)provider)).providing(ProviderTypes.RECIPES, ($, provider) -> FurnitureDataUtil.registerRecipes(context, provider));
    }

    public static void registerLootTables(DataGenContext context, LootTableProvider provider) {
        provider.fromRegistree(context.registree);
        provider.block(blocks -> {
            context.block(DataType.LOOT_TABLE, "planks", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "bricks", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "wool", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "carpet", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "dresser", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "stool", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "cushion", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "lockbox", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "drawer", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "chair", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "bookshelf", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "bed_single", block -> blocks.accept(block, blocks.createSinglePropConditionTable(block, (Property)BedBlock.PART, (Comparable)BedPart.HEAD)));
            context.block(DataType.LOOT_TABLE, "bed_double", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "door_single", block -> blocks.accept(block, blocks.createDoorTable(block)));
            context.block(DataType.LOOT_TABLE, "door_double", block -> blocks.accept(block, blocks.createDoorTable(block)));
            context.block(DataType.LOOT_TABLE, "desk_left", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "desk_right", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "painting_wide", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "painting_small", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "oven", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "chest", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "floor_light", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "chandelier", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "shelf", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "sofa", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "counter", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "wall_light", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "bench", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "wardrobe", block -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)));
            context.block(DataType.LOOT_TABLE, "table", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "stairs", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "slab", block -> blocks.accept(block, blocks.createSlabItemTable(block)));
            context.block(DataType.LOOT_TABLE, "fence", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "fence_gate", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "trapdoor", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "pressure_plate", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "button", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "hanging_sign", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
            context.block(DataType.LOOT_TABLE, "sign", arg_0 -> ((BlockLootSubProvider)blocks).dropSelf(arg_0));
        });
    }

    public static void registerBlockTags(DataGenContext context, IntrusiveTagProvider<Block> provider) {
        context.block(DataType.BLOCK_TAG, "planks", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.PLANKS));
        context.block(DataType.BLOCK_TAG, "bricks", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, Tags.Blocks.STONES));
        context.block(DataType.BLOCK_TAG, "wool", block -> FurnitureDataUtil.tag(provider, block, BlockTags.WOOL));
        context.block(DataType.BLOCK_TAG, "carpet", block -> FurnitureDataUtil.tag(provider, block, BlockTags.WOOL_CARPETS));
        context.block(DataType.BLOCK_TAG, "dresser", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "lockbox", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag));
        context.block(DataType.BLOCK_TAG, "drawer", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag));
        context.block(DataType.BLOCK_TAG, "chair", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "bookshelf", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED, BlockTags.ENCHANTMENT_POWER_PROVIDER));
        context.block(DataType.BLOCK_TAG, "bed_single", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.BEDS, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "bed_double", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.BEDS, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "door_single", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.doorTag.block(), BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "door_double", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.doorTag.block(), BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "desk_left", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "desk_right", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "painting_wide", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "painting_small", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag));
        context.block(DataType.BLOCK_TAG, "oven", block -> FurnitureDataUtil.tag(provider, block, BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES));
        context.block(DataType.BLOCK_TAG, "chest", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "floor_light", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "chandelier", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag));
        context.block(DataType.BLOCK_TAG, "shelf", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES));
        context.block(DataType.BLOCK_TAG, "sofa", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES));
        context.block(DataType.BLOCK_TAG, "counter", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES));
        context.block(DataType.BLOCK_TAG, "wall_light", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES));
        context.block(DataType.BLOCK_TAG, "bench", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, ApexTags.Blocks.SEAT_PER_BLOCK, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "wardrobe", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES, Tags.Blocks.RELOCATION_NOT_SUPPORTED));
        context.block(DataType.BLOCK_TAG, "table", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockItemPlacementEvent.RENDERABLES));
        context.block(DataType.BLOCK_TAG, "stairs", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.stairsTag));
        context.block(DataType.BLOCK_TAG, "slab", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.slabTag.block()));
        context.block(DataType.BLOCK_TAG, "fence", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.fenceTag.block()));
        context.block(DataType.BLOCK_TAG, "fence_gate", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.FENCE_GATES));
        context.block(DataType.BLOCK_TAG, "trapdoor", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.trapdoorTag.block()));
        context.block(DataType.BLOCK_TAG, "pressure_plate", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.pressurePlateTag.block()));
        context.block(DataType.BLOCK_TAG, "button", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, context.buttonTag.block()));
        context.block(DataType.BLOCK_TAG, "hanging_sign", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.CEILING_HANGING_SIGNS));
        context.block(DataType.BLOCK_TAG, "wall_hanging_sign", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.WALL_HANGING_SIGNS));
        context.block(DataType.BLOCK_TAG, "sign", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.STANDING_SIGNS));
        context.block(DataType.BLOCK_TAG, "wall_sign", block -> FurnitureDataUtil.tag(provider, block, context.mineableTag, BlockTags.WALL_SIGNS));
    }

    public static void registerItemTags(DataGenContext context, IntrusiveTagProvider<Item> provider) {
        context.item(DataType.ITEM_TAG, "planks", item -> FurnitureDataUtil.tag(provider, item, FantasyFurniture.FURNITURE_PLANKS));
        context.item(DataType.ITEM_TAG, "bricks", item -> FurnitureDataUtil.tag(provider, item, FantasyFurniture.FURNITURE_BRICKS));
        context.item(DataType.ITEM_TAG, "wool", item -> FurnitureDataUtil.tag(provider, item, FantasyFurniture.FURNITURE_WOOL));
        context.item(DataType.ITEM_TAG, "carpet", item -> FurnitureDataUtil.tag(provider, item, ItemTags.WOOL_CARPETS));
        context.item(DataType.ITEM_TAG, "bed_single", item -> FurnitureDataUtil.tag(provider, item, ItemTags.BEDS));
        context.item(DataType.ITEM_TAG, "bed_double", item -> FurnitureDataUtil.tag(provider, item, ItemTags.BEDS));
        context.item(DataType.ITEM_TAG, "door_single", item -> FurnitureDataUtil.tag(provider, item, context.doorTag.item()));
        context.item(DataType.ITEM_TAG, "door_double", item -> FurnitureDataUtil.tag(provider, item, context.doorTag.item()));
        context.item(DataType.ITEM_TAG, "oven", item -> FurnitureDataUtil.tag(provider, item, Tags.Items.PLAYER_WORKSTATIONS_FURNACES));
        context.item(DataType.ITEM_TAG, "stairs", item -> FurnitureDataUtil.tag(provider, item, ItemTags.STAIRS));
        context.item(DataType.ITEM_TAG, "slab", item -> FurnitureDataUtil.tag(provider, item, context.slabTag.item()));
        context.item(DataType.ITEM_TAG, "fence", item -> FurnitureDataUtil.tag(provider, item, context.fenceTag.item()));
        context.item(DataType.ITEM_TAG, "fence_gate", item -> FurnitureDataUtil.tag(provider, item, ItemTags.FENCE_GATES));
        context.item(DataType.ITEM_TAG, "trapdoor", item -> FurnitureDataUtil.tag(provider, item, context.trapdoorTag.item()));
        context.item(DataType.ITEM_TAG, "pressure_plate", item -> FurnitureDataUtil.tag(provider, item, context.pressurePlateTag.item()));
        context.item(DataType.ITEM_TAG, "button", item -> FurnitureDataUtil.tag(provider, item, context.buttonTag.item()));
        context.item(DataType.ITEM_TAG, "wall_hanging_sign", item -> FurnitureDataUtil.tag(provider, item, ItemTags.HANGING_SIGNS));
        context.item(DataType.ITEM_TAG, "sign", item -> FurnitureDataUtil.tag(provider, item, ItemTags.SIGNS));
    }

    @SafeVarargs
    public static <TRegistry> void tag(IntrusiveTagProvider<TRegistry> provider, TRegistry element, TagKey<TRegistry> ... tags) {
        for (TagKey<TRegistry> tag : tags) {
            if (tag == null) continue;
            ((IntrusiveTagBuilder)provider.tag(tag)).withElement(element);
        }
    }

    public static void registerRecipes(DataGenContext context, RecipeProvider provider) {
        context.block(DataType.RECIPE, "planks", block -> FurnitureDataUtil.conversionRecipe((TagKey<Item>)ItemTags.PLANKS, FantasyFurniture.FURNITURE_PLANKS, "has_planks", (ItemLike)block, provider));
        context.block(DataType.RECIPE, "bricks", block -> FurnitureDataUtil.conversionRecipe((TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, FantasyFurniture.FURNITURE_BRICKS, "has_bricks", (ItemLike)block, provider));
        context.block(DataType.RECIPE, "wool", block -> FurnitureDataUtil.conversionRecipe((TagKey<Item>)ItemTags.WOOL, FantasyFurniture.FURNITURE_WOOL, "has_wool", (ItemLike)block, provider));
        context.block(DataType.RECIPE, "carpet", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "dresser", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "stool", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "cushion", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "lockbox", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "drawer", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "chair", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "bookshelf", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "bed_single", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "bed_double", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "door_single", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "door_double", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "desk_left", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "desk_right", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "painting_wide", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "painting_small", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "oven", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "chest", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "floor_light", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "chandelier", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "shelf", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "sofa", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "counter", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "wall_light", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "bench", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "wardrobe", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "table", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "stairs", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "slab", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "fence", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "fence_gate", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "trapdoor", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "pressure_plate", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "button", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "hanging_sign", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
        context.block(DataType.RECIPE, "sign", block -> FurnitureDataUtil.furnitureStationRecipe(context, (ItemLike)block, provider));
    }

    public static void conversionRecipe(TagKey<Item> baseTag, TagKey<Item> furnitureTag, String hasKey, ItemLike result, RecipeProvider provider) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)provider.tag(baseTag), (Ingredient)provider.tag(furnitureTag)), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result).unlockedBy(hasKey, provider.has(baseTag)).save(provider.output(), RecipeProvider.recipeKeyWithPrefix((ItemLike)result, (String)"conversion/"));
    }

    public static void furnitureStationRecipe(DataGenContext context, ItemLike result, RecipeProvider provider) {
        Block wool = (Block)context.registree.getValue(Registries.BLOCK, "wool");
        Ingredient woolIngredient = wool == null ? null : Ingredient.of((ItemLike)wool);
        FurnitureStationRecipeBuilder.builder(RecipeCategory.MISC, Ingredient.of((ItemLike)context.family.getBaseBlock()), woolIngredient, provider.tag(FurnitureStationSetup.BINDING_AGENT), result).group(context.family.getRecipeGroupPrefix().orElse(null)).unlockedBy(context.family.getRecipeUnlockedBy().orElseGet(() -> RecipeProvider.getHasName((ItemLike)context.family.getBaseBlock())), provider.has((ItemLike)context.family.getBaseBlock())).save(provider.output(), RecipeProvider.recipeKeyWithPrefix((ItemLike)result, (String)"furniture_station/"));
    }

    public record DataGenContext(Registree registree, String englishName, BlockFamily family, TagKey<Block> mineableTag, TagPair doorTag, TagKey<Block> stairsTag, TagPair buttonTag, TagPair pressurePlateTag, TagPair trapdoorTag, TagPair fenceTag, TagPair slabTag, Multimap<DataType, String> exclusions) {
        public DataGenContext {
            exclusions = Multimaps.unmodifiableMultimap(exclusions);
        }

        public DataGenContext(Registree registree, String englishName, BlockFamily family, TagKey<Block> mineableTag, TagPair doorTag, TagKey<Block> stairsTag, TagPair buttonTag, TagPair pressurePlateTag, TagPair trapdoorTag, TagPair fenceTag, TagPair slabTag) {
            this(registree, englishName, family, mineableTag, doorTag, stairsTag, buttonTag, pressurePlateTag, trapdoorTag, fenceTag, slabTag, (Multimap<DataType, String>)HashMultimap.create());
        }

        public DataGenContext(Registree registree, String englishName, BlockFamily family, TagKey<Block> mineableTag, TagPair doorTag, TagKey<Block> stairsTag, TagPair buttonTag, TagPair pressurePlateTag, TagPair trapdoorTag, TagPair fenceTag, TagPair slabTag, Consumer<Multimap<DataType, String>> exclusions) {
            this(registree, englishName, family, mineableTag, doorTag, stairsTag, buttonTag, pressurePlateTag, trapdoorTag, fenceTag, slabTag, (Multimap<DataType, String>)((Multimap)Util.make((Object)HashMultimap.create(), exclusions)));
        }

        public boolean excluded(DataType dataType, String name) {
            return this.exclusions.get((Object)dataType).contains(name);
        }

        public void ifAllowed(DataType dataType, String name, Runnable runnable) {
            if (!this.excluded(dataType, name)) {
                runnable.run();
            }
        }

        public <TRegistry> boolean ifPresent(DataType dataType, ResourceKey<? extends Registry<TRegistry>> registryType, String name, Consumer<? super TRegistry> action) {
            if (this.excluded(dataType, name)) {
                return true;
            }
            Object value = this.registree.getValue(registryType, name);
            if (value != null) {
                action.accept(value);
                return true;
            }
            return false;
        }

        public boolean block(DataType dataType, String name, Consumer<? super Block> action) {
            return this.ifPresent(dataType, Registries.BLOCK, name, action);
        }

        public boolean item(DataType dataType, String name, Consumer<? super Item> action) {
            if (this.ifPresent(dataType, Registries.ITEM, name, action)) {
                return true;
            }
            return this.block(dataType, name, block -> action.accept(block.asItem()));
        }
    }

    public static enum DataType {
        LOOT_TABLE,
        BLOCK_TAG,
        ITEM_TAG,
        RECIPE,
        MODEL,
        LANGUAGE;

    }
}

