/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.FurnitureBlockEntities;
import dev.apexstudios.fantasyfurniture.block.BedDoubleBlock;
import dev.apexstudios.fantasyfurniture.block.BedSingleBlock;
import dev.apexstudios.fantasyfurniture.block.BenchBlock;
import dev.apexstudios.fantasyfurniture.block.BookshelfBlock;
import dev.apexstudios.fantasyfurniture.block.ChairBlock;
import dev.apexstudios.fantasyfurniture.block.ChandelierBlock;
import dev.apexstudios.fantasyfurniture.block.ChestBlock;
import dev.apexstudios.fantasyfurniture.block.CounterBlock;
import dev.apexstudios.fantasyfurniture.block.CushionBlock;
import dev.apexstudios.fantasyfurniture.block.DeskBlock;
import dev.apexstudios.fantasyfurniture.block.DrawerBlock;
import dev.apexstudios.fantasyfurniture.block.DresserBlock;
import dev.apexstudios.fantasyfurniture.block.FloorLightBlock;
import dev.apexstudios.fantasyfurniture.block.FurnitureDoorBlock;
import dev.apexstudios.fantasyfurniture.block.LockBoxBlock;
import dev.apexstudios.fantasyfurniture.block.OvenBlock;
import dev.apexstudios.fantasyfurniture.block.PaintingSmallBlock;
import dev.apexstudios.fantasyfurniture.block.PaintingWideBlock;
import dev.apexstudios.fantasyfurniture.block.ShelfBlock;
import dev.apexstudios.fantasyfurniture.block.SofaBlock;
import dev.apexstudios.fantasyfurniture.block.StoolBlock;
import dev.apexstudios.fantasyfurniture.block.TableBlock;
import dev.apexstudios.fantasyfurniture.block.WallLightBlock;
import dev.apexstudios.fantasyfurniture.block.WardrobeBlock;
import dev.apexstudios.fantasyfurniture.ctm.CtmPacks;
import dev.apexstudios.registree.api.Registree;
import dev.apexstudios.registree.api.holder.DeferredBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.world.poi.ExtendPoiTypesEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.mixins.BlockEntityTypeAccessor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.transfer.item.WorldlyContainerWrapper;

public interface FurnitureUtil {
    public static final Supplier<BlockBehaviour.Properties> PLANK_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    public static final Supplier<BlockBehaviour.Properties> STONE_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE);
    public static final Supplier<BlockBehaviour.Properties> WOOL_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WHITE_WOOL);
    public static final Supplier<BlockBehaviour.Properties> CARPET_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WHITE_CARPET);
    public static final Supplier<BlockBehaviour.Properties> DRESSER_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CHEST).pushReaction(PushReaction.BLOCK);
    public static final Supplier<BlockBehaviour.Properties> STOOL_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> CUSHION_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> LOCKBOX_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> DRAWER_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> CHAIR_PROPERTIES = FurnitureUtil.mutating(PLANK_PROPERTIES, properties -> properties.pushReaction(PushReaction.BLOCK));
    public static final Supplier<BlockBehaviour.Properties> BOOKSHELF_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> BED_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WHITE_BED).pushReaction(PushReaction.BLOCK);
    public static final Supplier<BlockBehaviour.Properties> DOOR_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_DOOR).pushReaction(PushReaction.BLOCK);
    public static final Supplier<BlockBehaviour.Properties> DESK_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> PAINTING_WIDE_PROPERTIES = CHAIR_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> PAINTING_SMALL_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> OVEN_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.SMOKER);
    public static final Supplier<BlockBehaviour.Properties> CHEST_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> FLOOR_LIGHT_PROPERTIES = FurnitureUtil.mutating(PLANK_PROPERTIES, properties -> properties.pushReaction(PushReaction.BLOCK).lightLevel(blockState -> MultiBlock.getIndex((BlockState)blockState) == 1 ? 14 : 0));
    public static final Supplier<BlockBehaviour.Properties> CHANDELIER_PROPERTIES = FurnitureUtil.mutating(PLANK_PROPERTIES, properties -> properties.lightLevel(blockState -> 14));
    public static final Supplier<BlockBehaviour.Properties> SHELF_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> SOFA_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> COUNTER_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> WALL_LIGHT_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.WALL_TORCH);
    public static final Supplier<BlockBehaviour.Properties> BENCH_PROPERTIES = FurnitureUtil.mutating(PLANK_PROPERTIES, properties -> properties.pushReaction(PushReaction.BLOCK));
    public static final Supplier<BlockBehaviour.Properties> WARDROBE_PROPERTIES = DRESSER_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> TABLE_PROPERTIES = PLANK_PROPERTIES;
    public static final Supplier<BlockBehaviour.Properties> STAIRS_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_STAIRS);
    public static final Supplier<BlockBehaviour.Properties> SLAB_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SLAB);
    public static final Supplier<BlockBehaviour.Properties> FENCE_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_FENCE);
    public static final Supplier<BlockBehaviour.Properties> FENCE_GATE_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE);
    public static final Supplier<BlockBehaviour.Properties> TRAPDOOR_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR);
    public static final Supplier<BlockBehaviour.Properties> PRESSURE_PLATE_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE);
    public static final Supplier<BlockBehaviour.Properties> HANGING_SIGN_BLOCK_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN);
    public static final Supplier<BlockBehaviour.Properties> WALL_HANGING_SIGN_BLOCK_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN);
    public static final Supplier<BlockBehaviour.Properties> SIGN_BLOCK_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SIGN);
    public static final Supplier<BlockBehaviour.Properties> WALL_SIGN_BLOCK_PROPERTIES = () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN);
    public static final Supplier<Item.Properties> SIGN_ITEM_PROPERTIES = () -> new Item.Properties().stacksTo(16).useBlockDescriptionPrefix();

    public static <TBlock extends Block> DeferredBlock<TBlock> planks(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("planks", factory, PLANK_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends Block> DeferredBlock<TBlock> bricks(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("bricks", factory, STONE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends Block> DeferredBlock<TBlock> wool(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("wool", factory, WOOL_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends CarpetBlock> DeferredBlock<TBlock> carpet(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("carpet", factory, CARPET_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends DresserBlock> DeferredBlock<TBlock> dresser(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("dresser", factory, DRESSER_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends StoolBlock> DeferredBlock<TBlock> stool(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("stool", factory, STOOL_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends CushionBlock> DeferredBlock<TBlock> cushion(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("cushion", factory, CUSHION_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends LockBoxBlock> DeferredBlock<TBlock> lockbox(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("lockbox", factory, LOCKBOX_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends DrawerBlock> DeferredBlock<TBlock> drawer(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("drawer", factory, DRAWER_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends ChairBlock> DeferredBlock<TBlock> chair(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("chair", factory, CHAIR_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends BookshelfBlock> DeferredBlock<TBlock> bookshelf(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("bookshelf", factory, BOOKSHELF_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends BedSingleBlock> DeferredBlock<TBlock> bedSingle(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("bed_single", factory, BED_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends BedDoubleBlock> DeferredBlock<TBlock> bedDouble(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("bed_double", factory, BED_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends FurnitureDoorBlock> DeferredBlock<TBlock> doorSingle(Registree registree, BlockSetType blockSet, BiFunction<BlockBehaviour.Properties, BlockSetType, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("door_single", properties -> (FurnitureDoorBlock)((Object)((Object)factory.apply((BlockBehaviour.Properties)properties, blockSet))), DOOR_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends FurnitureDoorBlock> DeferredBlock<TBlock> doorDouble(Registree registree, BlockSetType blockSet, BiFunction<BlockBehaviour.Properties, BlockSetType, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("door_double", properties -> (FurnitureDoorBlock)((Object)((Object)factory.apply((BlockBehaviour.Properties)properties, blockSet))), DOOR_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends DeskBlock> DeferredBlock<TBlock> desk(Registree registree, boolean left, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock(left ? "desk_left" : "desk_right", factory, DESK_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends PaintingWideBlock> DeferredBlock<TBlock> paintingWide(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("painting_wide", factory, PAINTING_WIDE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends PaintingSmallBlock> DeferredBlock<TBlock> paintingSmall(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("painting_small", factory, PAINTING_SMALL_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends OvenBlock> DeferredBlock<TBlock> oven(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("oven", factory, OVEN_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends ChestBlock> DeferredBlock<TBlock> chest(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("chest", factory, CHEST_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends FloorLightBlock> DeferredBlock<TBlock> floorLight(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("floor_light", factory, FLOOR_LIGHT_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends ChandelierBlock> DeferredBlock<TBlock> chandelier(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("chandelier", factory, CHANDELIER_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends ShelfBlock> DeferredBlock<TBlock> shelf(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("shelf", factory, SHELF_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends SofaBlock> DeferredBlock<TBlock> sofa(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("sofa", factory, SOFA_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends CounterBlock> DeferredBlock<TBlock> counter(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("counter", factory, COUNTER_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends WallLightBlock> DeferredBlock<TBlock> wallLight(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("wall_light", factory, WALL_LIGHT_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends BenchBlock> DeferredBlock<TBlock> bench(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("bench", factory, BENCH_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends WardrobeBlock> DeferredBlock<TBlock> wardrobe(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("wardrobe", factory, WARDROBE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static <TBlock extends TableBlock> DeferredBlock<TBlock> table(Registree registree, Function<BlockBehaviour.Properties, TBlock> factory) {
        DeferredBlock block = registree.registerBlock("table", factory, TABLE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<StairBlock> stairs(Registree registree, Supplier<? extends Block> baseBlock) {
        DeferredBlock block = registree.registerBlock("stairs", properties -> new StairBlock(((Block)baseBlock.get()).defaultBlockState(), properties), STAIRS_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<SlabBlock> slab(Registree registree) {
        DeferredBlock block = registree.registerBlock("slab", SlabBlock::new, SLAB_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<FenceBlock> fence(Registree registree) {
        DeferredBlock block = registree.registerBlock("fence", FenceBlock::new, FENCE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<FenceGateBlock> fenceGate(Registree registree, WoodType woodType) {
        DeferredBlock block = registree.registerBlock("fence_gate", properties -> new FenceGateBlock(woodType, properties), FENCE_GATE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<TrapDoorBlock> trapdoor(Registree registree, BlockSetType blockSet) {
        DeferredBlock block = registree.registerBlock("trapdoor", properties -> new TrapDoorBlock(blockSet, properties), TRAPDOOR_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static DeferredBlock<PressurePlateBlock> pressurePlate(Registree registree, BlockSetType blockSet) {
        DeferredBlock block = registree.registerBlock("pressure_plate", properties -> new PressurePlateBlock(blockSet, properties), PRESSURE_PLATE_PROPERTIES);
        registree.registerSimpleBlockItem((DeferredHolder)block);
        return block;
    }

    public static SignPair<CeilingHangingSignBlock, WallHangingSignBlock> hangingSign(Registree registree, WoodType woodType) {
        DeferredBlock ceilingSign = registree.registerBlock("hanging_sign", properties -> new CeilingHangingSignBlock(woodType, properties), HANGING_SIGN_BLOCK_PROPERTIES);
        DeferredBlock wallSign = registree.registerBlock("wall_hanging_sign", properties -> new WallHangingSignBlock(woodType, properties), FurnitureUtil.mutating(WALL_HANGING_SIGN_BLOCK_PROPERTIES, properties -> properties.overrideLootTable(((CeilingHangingSignBlock)ceilingSign.value()).getLootTable())));
        registree.registerItem("hanging_sign", properties -> new HangingSignItem((Block)ceilingSign.value(), (Block)wallSign.value(), properties), SIGN_ITEM_PROPERTIES);
        return new SignPair<CeilingHangingSignBlock, WallHangingSignBlock>(ceilingSign, wallSign);
    }

    public static SignPair<StandingSignBlock, WallSignBlock> sign(Registree registree, WoodType woodType) {
        DeferredBlock standingSign = registree.registerBlock("sign", properties -> new StandingSignBlock(woodType, properties), SIGN_BLOCK_PROPERTIES);
        DeferredBlock wallSign = registree.registerBlock("wall_sign", properties -> new WallSignBlock(woodType, properties), FurnitureUtil.mutating(WALL_SIGN_BLOCK_PROPERTIES, properties -> properties.overrideLootTable(((StandingSignBlock)standingSign.value()).getLootTable())));
        registree.registerItem("sign", properties -> new SignItem((Block)standingSign.value(), (Block)wallSign.value(), properties), SIGN_ITEM_PROPERTIES);
        return new SignPair<StandingSignBlock, WallSignBlock>(standingSign, wallSign);
    }

    public static ResourceKey<CreativeModeTab> creativeModeTab(Registree registree, ItemLike displayItem) {
        return registree.registerCreativeModeTab("furniture_set", () -> new ItemStack(displayItem), (parameters, output) -> registree.asLookup(Registries.ITEM).filterFeatures(parameters.enabledFeatures()).listElements().filter(Holder::isBound).map(Holder::value).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0)));
    }

    private static <T> Supplier<T> mutating(Supplier<T> initial, Consumer<T> mutator) {
        return () -> {
            Object properties = initial.get();
            mutator.accept(properties);
            return properties;
        };
    }

    public static void registerEvents(IEventBus modBus, Registree registree, WoodType woodType) {
        FantasyFurniture.FURNITURE_MODS.add(registree.namespace());
        CtmPacks.register(registree);
        modBus.addListener(BlockEntityTypeAddBlocksEvent.class, event -> {
            FurnitureUtil.appendValidBlocks((BlockEntityType)FurnitureBlockEntities.INVENTORY.value(), Names.blocks(registree, "dresser", "lockbox", "drawer", "desk_left", "desk_right", "chest", "counter", "wardrobe"));
            FurnitureUtil.appendValidBlocks((BlockEntityType)FurnitureBlockEntities.BOOKSHELF.value(), Names.blocks(registree, "bookshelf"));
            FurnitureUtil.appendValidBlocks(BlockEntityType.SMOKER, Names.blocks(registree, "oven"));
            FurnitureUtil.appendValidBlocks(BlockEntityType.HANGING_SIGN, Names.blocks(registree, "hanging_sign", "wall_hanging_sign"));
            FurnitureUtil.appendValidBlocks(BlockEntityType.SIGN, Names.blocks(registree, "sign", "wall_sign"));
        });
        modBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> {
            WoodType.register((WoodType)woodType);
            BlockSetType.register((BlockSetType)woodType.setType());
        }));
        modBus.addListener(ExtendPoiTypesEvent.class, event -> {
            FurnitureUtil.registerHomePoi(event, registree, "bed_single");
            FurnitureUtil.registerHomePoi(event, registree, "bed_double");
            Names.block(registree, "oven", block -> event.addBlockToPoi(PoiTypes.BUTCHER, block));
        });
        modBus.addListener(RegisterCapabilitiesEvent.class, event -> Names.block(registree, "oven", block -> {
            event.registerBlockEntity(Capabilities.Item.BLOCK, BlockEntityType.SMOKER, WorldlyContainerWrapper::new);
            if (!(block instanceof MultiBlock)) {
                return;
            }
            event.registerBlock(Capabilities.Item.BLOCK, (level, pos, blockState, blockEntity, side) -> {
                if (blockEntity == null) {
                    blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
                }
                if (!(blockEntity instanceof SmokerBlockEntity)) {
                    return null;
                }
                SmokerBlockEntity smoker = (SmokerBlockEntity)blockEntity;
                return new WorldlyContainerWrapper((WorldlyContainer)smoker, side);
            }, new Block[]{block});
        }));
        modBus.addListener(FMLClientSetupEvent.class, event -> event.enqueueWork(() -> {
            Names.block(registree, "hanging_sign", block -> FurnitureUtil.registerMaterial(woodType, Sheets.HANGING_SIGN_MATERIALS, Sheets.HANGING_SIGN_MAPPER, true));
            Names.block(registree, "sign", block -> FurnitureUtil.registerMaterial(woodType, Sheets.SIGN_MATERIALS, Sheets.SIGN_MAPPER, false));
        }));
        registree.registerEvents(modBus);
    }

    public static VoxelShape getShape(VoxelShape shape, BlockState blockState, BlockPos worldPos) {
        return MultiBlock.fixShape((VoxelShape)shape, (BlockState)blockState, (BlockPos)worldPos);
    }

    public static VoxelShape getShape(Map<Direction, VoxelShape> shapes, BlockState blockState, BlockPos worldPos) {
        Direction facing = (Direction)blockState.getValueOrElse((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH);
        return FurnitureUtil.getShape(shapes.get(facing), blockState, worldPos);
    }

    private static void registerMaterial(WoodType woodType, Map<WoodType, Material> materials, MaterialMapper materialMapper, boolean hanging) {
        materials.put(woodType, materialMapper.apply(ResourceLocation.parse((String)woodType.name())));
    }

    private static void registerHomePoi(ExtendPoiTypesEvent event, Registree registree, String name) {
        Names.block(registree, name, block -> event.addStatesToPoi(PoiTypes.HOME, block.getStateDefinition().getPossibleStates().stream().filter(blockState -> blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD).collect(Collectors.toSet())));
    }

    private static void appendValidBlocks(BlockEntityType<?> blockEntityType, Block ... blocks) {
        if (blocks.length == 0) {
            return;
        }
        HashSet validBlocks = Sets.newHashSet((Iterable)blockEntityType.getValidBlocks());
        Collections.addAll(validBlocks, blocks);
        ((BlockEntityTypeAccessor)blockEntityType).neoforge$setValidBlocks((Set)validBlocks);
    }

    public static interface Names {
        public static final String PLANKS = "planks";
        public static final String BRICKS = "bricks";
        public static final String WOOL = "wool";
        public static final String CARPET = "carpet";
        public static final String DRESSER = "dresser";
        public static final String STOOL = "stool";
        public static final String CUSHION = "cushion";
        public static final String LOCKBOX = "lockbox";
        public static final String DRAWER = "drawer";
        public static final String CHAIR = "chair";
        public static final String BOOKSHELF = "bookshelf";
        public static final String BED_SINGLE = "bed_single";
        public static final String BED_DOUBLE = "bed_double";
        public static final String DOOR_SINGLE = "door_single";
        public static final String DOOR_DOUBLE = "door_double";
        public static final String DESK_LEFT = "desk_left";
        public static final String DESK_RIGHT = "desk_right";
        public static final String PAINTING_WIDE = "painting_wide";
        public static final String PAINTING_SMALL = "painting_small";
        public static final String OVEN = "oven";
        public static final String CHEST = "chest";
        public static final String FLOOR_LIGHT = "floor_light";
        public static final String CHANDELIER = "chandelier";
        public static final String SHELF = "shelf";
        public static final String SOFA = "sofa";
        public static final String COUNTER = "counter";
        public static final String WALL_LIGHT = "wall_light";
        public static final String BENCH = "bench";
        public static final String WARDROBE = "wardrobe";
        public static final String TABLE = "table";
        public static final String STAIRS = "stairs";
        public static final String SLAB = "slab";
        public static final String FENCE = "fence";
        public static final String FENCE_GATE = "fence_gate";
        public static final String TRAPDOOR = "trapdoor";
        public static final String PRESSURE_PLATE = "pressure_plate";
        public static final String BUTTON = "button";
        public static final String HANGING_SIGN = "hanging_sign";
        public static final String WALL_HANGING_SIGN = "wall_hanging_sign";
        public static final String SIGN = "sign";
        public static final String WALL_SIGN = "wall_sign";
        public static final String CREATIVE_MODE_TAB = "furniture_set";

        public static void block(Registree registree, String name, Consumer<? super Block> action) {
            Block block = (Block)registree.getValue(Registries.BLOCK, name);
            if (block != null) {
                action.accept((Block)block);
            }
        }

        public static void creativeModeTab(Registree registree, Consumer<ResourceKey<CreativeModeTab>> action) {
            registree.get(Registries.CREATIVE_MODE_TAB, CREATIVE_MODE_TAB).ifPresent(holder -> action.accept(holder.getKey()));
        }

        public static Block[] blocks(Registree registree, String ... names) {
            ArrayList blocks = Lists.newArrayList();
            for (String name : names) {
                Names.block(registree, name, blocks::add);
            }
            return (Block[])blocks.toArray(Block[]::new);
        }
    }

    public record SignPair<TSign extends SignBlock, TWall extends SignBlock>(DeferredBlock<TSign> sign, DeferredBlock<TWall> wall) {
    }
}

