/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data;

import com.google.common.collect.Maps;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderListenerContext;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public abstract sealed class ProviderTypeImpl<TProvider>
implements ProviderType<TProvider> {
    private static final Map<ResourceLocation, ProviderType<?>> REGISTRY = Maps.newHashMap();
    private final ResourceLocation registryName;

    protected ProviderTypeImpl(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public ResourceLocation registryName() {
        return this.registryName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProviderType) {
            ProviderType other = (ProviderType)obj;
            return this.registryName.equals((Object)other.registryName());
        }
        return false;
    }

    public int hashCode() {
        return this.registryName.hashCode();
    }

    public String toString() {
        return "ProviderType{" + String.valueOf(this.registryName) + "}";
    }

    public static <TProvider> ProviderType<TProvider> register(ResourceLocation registryName, Function<ProviderListenerContext, TProvider> factory) {
        return ProviderTypeImpl.register(new Main<TProvider>(registryName, factory));
    }

    public static <TProvider> ProviderType<TProvider> registerForDist(ResourceLocation registryName, Dist dist, Supplier<Function<ProviderListenerContext, TProvider>> factory) {
        return ProviderTypeImpl.register(new ForDist<TProvider>(registryName, dist, factory));
    }

    public static <TProvider> ProviderType<TProvider> register(ProviderType<TProvider> providerType) {
        if (REGISTRY.putIfAbsent(providerType.registryName(), providerType) != null) {
            throw new IllegalStateException("Duplicate ProviderType: " + String.valueOf(providerType.registryName()));
        }
        return providerType;
    }

    private static final class Main<TProvider>
    extends ProviderTypeImpl<TProvider> {
        private final Function<ProviderListenerContext, TProvider> factory;

        private Main(ResourceLocation registryName, Function<ProviderListenerContext, TProvider> factory) {
            super(registryName);
            this.factory = factory;
        }

        @Override
        public TProvider create(ProviderListenerContext context) {
            return this.factory.apply(context);
        }
    }

    private static final class ForDist<TProvider>
    extends ProviderTypeImpl<TProvider> {
        private final Dist dist;
        private final Supplier<Function<ProviderListenerContext, TProvider>> factory;

        private ForDist(ResourceLocation registryName, Dist dist, Supplier<Function<ProviderListenerContext, TProvider>> factory) {
            super(registryName);
            this.dist = dist;
            this.factory = factory;
        }

        @Override
        public TProvider create(ProviderListenerContext context) {
            return FMLEnvironment.getDist() == this.dist ? (TProvider)this.factory.get().apply(context) : null;
        }
    }
}

