/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.multiblock;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class MultiBlockProperty
extends Property<Integer> {
    public static final String DEFAULT_NAME = "multi_block_index";
    private final List<Vector3ic> positions;
    private final IntegerProperty internal;

    public MultiBlockProperty(String name, Collection<Vector3ic> positions) {
        super(name, Integer.class);
        if (positions.size() <= 1) {
            throw new IllegalArgumentException("Multi blocks must contain more than the origin point");
        }
        this.positions = List.copyOf(positions);
        this.internal = IntegerProperty.create((String)name, (int)0, (int)(positions.size() - 1));
    }

    public List<Vector3ic> getPositions() {
        return this.positions;
    }

    public List<Integer> getPossibleValues() {
        return this.internal.getPossibleValues();
    }

    public String getName(Integer value) {
        return this.internal.getName(value);
    }

    public Optional<Integer> getValue(String value) {
        return this.internal.getValue(value);
    }

    public int getInternalIndex(Integer value) {
        return this.internal.getInternalIndex(value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof MultiBlockProperty)) {
            return false;
        }
        MultiBlockProperty property = (MultiBlockProperty)((Object)other);
        if (!this.internal.equals((Object)property.internal)) {
            return false;
        }
        return this.positions.equals(property.positions);
    }

    public int generateHashCode() {
        return this.internal.generateHashCode();
    }

    public static MultiBlockProperty create(String name, Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return new MultiBlockProperty(name, builder.positions);
    }

    public static MultiBlockProperty create(Consumer<Builder> consumer) {
        return MultiBlockProperty.create(DEFAULT_NAME, consumer);
    }

    public static final class Builder {
        private final Set<Vector3ic> positions = Sets.newLinkedHashSet();

        private Builder() {
            this.with(0, 0, 0);
        }

        public Builder with(int x, int y, int z) {
            return this.with((Vector3ic)new Vector3i(x, y, z));
        }

        public Builder with(Vector3ic position) {
            this.positions.add(position);
            return this;
        }

        public Builder sized(int sizeX, int sizeY, int sizeZ) {
            for (int y = 0; y < sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    for (int z = 0; z < sizeZ; ++z) {
                        this.with(x, y, z);
                    }
                }
            }
            return this;
        }

        public Builder sized(int size) {
            return this.sized(size, size, size);
        }
    }
}

